<?php
session_start();
include_once('api/db.php');

// Create PDO connection
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Auto-login via cookies (Remember Me)
if (isset($_COOKIE['pkl_email']) && isset($_COOKIE['pkl_password'])) {
    $email = $_COOKIE['pkl_email'];
    $password = $_COOKIE['pkl_password']; // stored as plain (can hash if needed)

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email AND password = md5(:password) AND is_active = 1 LIMIT 1");
    $stmt->execute(['email' => $email, 'password' => $password]);
    $user = $stmt->fetch();

    if ($user) {
        $_SESSION['pkl_user_id'] = $user['id'];
        $_SESSION['pkl_email'] = $user['email'];
        header("Location: index.php");
        exit();
    }
}

// Manual login via form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email AND password = md5(:password) LIMIT 1");
    $stmt->execute(['email' => $email, 'password' => $password]);
    $user = $stmt->fetch();

    if ($user) {
        $_SESSION['pkl_user_id'] = $user['id'];
        $_SESSION['pkl_email'] = $user['email'];

        if (isset($_POST['rememberMe'])) {
            setcookie('ipl_email', $email, time() + (86400 * 30), "/"); // 30 days
            setcookie('ipl_password', $password, time() + (86400 * 30), "/"); // optional: consider hashing
        }

        header("Location: index.php");
        exit();
    } else {
        $error = "Invalid email or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

	<meta charset="UTF-8">
	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="Description" content="">
	<meta name="Author" content="">
	<meta name="Keywords" content="" />

	<!-- Title -->
	<title> GSIQ </title>

	<!-- Favicon -->
	<link rel="icon" href="assets/img/brand/favicon.png" type="image/x-icon" />

	<!-- Icons css -->
	<link href="assets/css/icons.css" rel="stylesheet">

	<!-- Bootstrap css -->
	<link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">

	<!-- style css -->
	<link href="assets/css/style.css" rel="stylesheet">

	<!--- Animations css-->
	<link href="assets/css/animate.css" rel="stylesheet">

</head>

<body class="ltr error-page1 main-body bg-light text-dark error-3">


	<!-- Loader -->
	<div id="global-loader">
		<img src="assets/img/loader.svg" class="loader-img" alt="Loader">
	</div>
	<!-- /Loader -->

	<!-- Page -->
	<div class="page">

		<div class="main-container container-fluid">
			<div class="row no-gutter">
				<!-- The image half -->
				<div class="col-md-6 col-lg-6 col-xl-7 d-none d-md-flex bg-primary-transparent" style="background-color: #ef1c26 !important;">
					<div class="row wd-100p mx-auto text-center">
						<div class="col-md-12 col-lg-12 col-xl-12 my-auto mx-auto wd-100p">
							<img src="assets/img/media/login.png"
								class="my-auto ht-xl-80p wd-md-100p wd-xl-80p mx-auto" alt="logo">
						</div>
					</div>
				</div>
				<!-- The content half -->
				<div class="col-md-6 col-lg-6 col-xl-5 bg-white py-4">
					<div class="login d-flex align-items-center py-2">
						<!-- Demo content-->
						<div class="container p-0">
							<div class="row">
								<div class="col-md-10 col-lg-10 col-xl-9 mx-auto">
									<div class="card-sigin">
										<div class="mb-5 d-flex">
												<img src="assets/img/brand/logo.png"
													class="sign-favicon-a ht-40" alt="logo">
												<img src="assets/img/brand/logo-white.png"
													class="sign-favicon-b ht-40" alt="logo">
											</a>											
										</div>
										<div class="card-sigin">
											<div class="main-signup-header">
												<h2>Welcome back!</h2>
												<h5 class="fw-semibold mb-4">Please sign in to continue.</h5>
												<form action="" method="post" enctype="multipart/form-data">
													<div class="form-group">
														<label>User Name</label> <input class="form-control"
															placeholder="Enter your user name" type="text" name="email" required>
													</div>
													<div class="form-group">
														<label>Password</label> <input class="form-control"
															placeholder="Enter your password" type="password" name="password" required>
													</div><button type="submit" class="btn btn-danger btn-block">Sign
														In</button>

												</form>
												
												<?php
												if(!empty($error)) {
													echo '<div class="alert alert-warning fade show mt-1" role="alert">
														<strong>Sorry! </strong> User name or password is incorrect.
													</div>';
												}
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div><!-- End -->
					</div>
				</div><!-- End -->
			</div>
		</div>

	</div>
	<!-- End Page -->

	<!-- JQuery min js -->
	<script src="assets/plugins/jquery/jquery.min.js"></script>

	<!-- Bootstrap Bundle js -->
	<script src="assets/plugins/bootstrap/js/popper.min.js"></script>
	<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>

	<!-- Moment js -->
	<script src="assets/plugins/moment/moment.js"></script>

	<!-- P-scroll js -->
	<script src="assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>

	<!-- eva-icons js -->
	<script src="assets/js/eva-icons.min.js"></script>

	<!-- Rating js-->
	<script src="assets/plugins/ratings-2/jquery.star-rating.js"></script>
	<script src="assets/plugins/ratings-2/star-rating.js"></script>

	<!--themecolor js-->
	<script src="assets/js/themecolor.js"></script>

	<!-- custom js -->
	<script src="assets/js/custom.js"></script>

</body>

</html>