// Chart for A2
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq1').getContext('2d');

    const data = {
        labels: ['1-3', '4-7', '8-15', '16+'],
        datasets: [{
            data: [32, 28, 24, 16],
            backgroundColor: [
                'rgba(75, 192, 192, 0.6)',
                'rgba(255, 159, 64, 0.6)',
                'rgba(153, 102, 255, 0.6)',
                'rgba(255, 99, 132, 0.6)'
            ],
            borderColor: [
                'rgba(75, 192, 192, 1)',
                'rgba(255, 159, 64, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 99, 132, 1)'
            ],
            borderWidth: 1
        }]
    };

    const config = {
        type: 'pie',
        data: data,
        options: {
            responsive: false,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'right'
                },
                datalabels: {
                    color: '#000',
                    formatter: (value, context) => {
                        return value + '%';
                    },
                    font: {
                        weight: 'bold'
                    }
                }
            }
        },
        plugins: [ChartDataLabels]
    };
    window.Q1ChartInstance = new Chart(ctx, config);


    // document.getElementById('exportBtn_q1').addEventListener('click', function () {
    //     const imageUrl = window.Q1ChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'a2.png';
    //     link.click();
    // });


    document.getElementById('exportBtn_q1').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'a2.png');
    });


});


// Chart for A3
document.addEventListener("DOMContentLoaded", function () {
    const ctx2 = document.getElementById('chartq2').getContext('2d');

    const platformLabels = [
        'OTT (e.g., JioCinema)',
        'Social Media',
        'Live TV',
        'YouTube Highlights',
        'IPLT20.com',
        'In Stadium'
    ];

    const platformData = [82, 72, 64, 59, 25, 8];

    const barChartConfig = {
        type: 'bar',
        data: {
            labels: platformLabels,
            datasets: [{
                label: 'Percentage (%)',
                data: platformData,
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y', // ✅ Make it horizontal
            scales: {
                x: {
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        autoSkip: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const barChartInstance = new Chart(ctx2, barChartConfig);

    // Export to PNG
    // document.getElementById('exportBtn_q2').addEventListener('click', function () {
    //     const imageUrl = barChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'a3.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q2').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'a3.png');
    });
});

// Chart for A4
document.addEventListener("DOMContentLoaded", function () {
    const ctx2 = document.getElementById('chartq3').getContext('2d');

    const platformLabels = [
        '1',
        '2',
        '3',
        '4',
        '5'
    ];

    const platformData = [3, 6, 23, 35, 33];

    const barChartConfig = {
        type: 'bar',
        data: {
            labels: platformLabels,
            datasets: [{
                label: 'Percentage (%)',
                data: platformData,
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            scales: {
                x: {
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        autoSkip: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const barChartInstance = new Chart(ctx2, barChartConfig);

    // Export to PNG
    // document.getElementById('exportBtn_q3').addEventListener('click', function () {
    //     const imageUrl = barChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'a4.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q3').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'a4.png');
    });
});

// Chart for A5
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq4').getContext('2d');

    const data = {
        labels: ['Yes', 'No'],
        datasets: [{
            data: [61, 39],
            backgroundColor: [
                'rgba(75, 192, 192, 0.6)',
                'rgba(255, 159, 64, 0.6)'
            ],
            borderColor: [
                'rgba(75, 192, 192, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 1
        }]
    };

    const config = {
        type: 'pie',
        data: data,
        options: {
            responsive: false,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'right'
                },
                datalabels: {
                    color: '#000',
                    formatter: (value, context) => {
                        return value + '%';
                    },
                    font: {
                        weight: 'bold'
                    }
                }
            }
        },
        plugins: [ChartDataLabels]
    };
    window.Q1ChartInstance = new Chart(ctx, config);


    // document.getElementById('exportBtn_q4').addEventListener('click', function () {
    //     const imageUrl = window.Q1ChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'a5.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q4').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'a5.png');
    });

});

// Chart for B2
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq5').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const stronglyRecall = [69, 55, 46, 41, 42, 32, 36, 24];
    const somewhatRecall = [24, 28, 33, 36, 33, 38, 30, 31];
    const noRecall = [7, 17, 21, 23, 25, 30, 34, 45];

    const stackedChartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Strongly Recall',
                    data: stronglyRecall,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Somewhat Recall',
                    data: somewhatRecall,
                    backgroundColor: 'rgba(255, 205, 86, 0.7)',
                    borderColor: 'rgba(255, 205, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No Recall',
                    data: noRecall,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y', // Horizontal
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const stackedChartInstance = new Chart(ctx, stackedChartConfig);

    // Export PNG
    // document.getElementById('exportBtn_q5').addEventListener('click', function () {
    //     const imageUrl = stackedChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'b2.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q5').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'b2.png');
    });
});

// Chart for C1
document.addEventListener("DOMContentLoaded", function () {
    const ctx2 = document.getElementById('chartq6').getContext('2d');

    const platformLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres	',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const platformData = [4.5, 4.2, 3.9, 3.7, 3.8, 3.2, 3.5, 2.9];

    const barChartConfig = {
        type: 'bar',
        data: {
            labels: platformLabels,
            datasets: [{
                label: 'Percentage (%)',
                data: platformData,
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            scales: {
                x: {
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        autoSkip: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const barChartInstance = new Chart(ctx2, barChartConfig);

    // Export to PNG
    // document.getElementById('exportBtn_q6').addEventListener('click', function () {
    //     const imageUrl = barChartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'c1.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q6').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'c1.png');
    });
});

// Chart for C2
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq7').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const veryLikely = [52, 38, 33, 28, 30, 21, 27, 19];
    const maybe = [36, 39, 40, 45, 40, 47, 42, 33];
    const notAtAll = [12, 23, 27, 27, 30, 32, 31, 48];

    const config = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Very Likely (%)',
                    data: veryLikely,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Maybe (%)',
                    data: maybe,
                    backgroundColor: 'rgba(255, 205, 86, 0.7)',
                    borderColor: 'rgba(255, 205, 86, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not at All (%)',
                    data: notAtAll,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y',
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, config);

    // document.getElementById('exportBtn_q7').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'c2.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q7').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'c2.png');
    });
});

// Chart for C3
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq8').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const yesData = [81, 74, 70, 67, 63, 59, 61, 48];
    const noData = [8, 10, 13, 14, 18, 21, 19, 26];
    const notSureData = [11, 16, 17, 19, 19, 20, 20, 26];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Yes (%)',
                    data: yesData,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No (%)',
                    data: noData,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not Sure (%)',
                    data: notSureData,
                    backgroundColor: 'rgba(201, 203, 207, 0.7)',
                    borderColor: 'rgba(201, 203, 207, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y',
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export to PNG
    // document.getElementById('exportBtn_q8').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'c3.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q8').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'c3.png');
    });
});

// Chart for D1
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq9').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const yesData = [75, 61, 52, 57, 46, 43, 39, 30];
    const noData = [16, 25, 31, 28, 36, 37, 41, 50];
    const notSureData = [9, 14, 17, 15, 18, 20, 20, 20];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Yes (%)',
                    data: yesData,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No (%)',
                    data: noData,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not Sure (%)',
                    data: notSureData,
                    backgroundColor: 'rgba(201, 203, 207, 0.7)',
                    borderColor: 'rgba(201, 203, 207, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y',
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export chart as PNG
    // document.getElementById('exportBtn_q9').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'd1.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q9').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'd1.png');
    });
});

// Chart for D3
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq10').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'MY11Circle',
        'Ceat Tyres',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const yesData = [42, 28, 34, 22, 24, 18, 20, 15];
    const noData = [45, 55, 50, 61, 56, 63, 58, 65];
    const notSureData = [13, 17, 16, 17, 20, 19, 22, 20];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Yes (%)',
                    data: yesData,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No (%)',
                    data: noData,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not Sure (%)',
                    data: notSureData,
                    backgroundColor: 'rgba(201, 203, 207, 0.7)',
                    borderColor: 'rgba(201, 203, 207, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y',
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    grid: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export to PNG
    // document.getElementById('exportBtn_q10').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'd3.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q10').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'd3.png');
    });

});

// Chart for E1 vs E2
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq11').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const beforeIPL = [4.1, 3.5, 3.2, 2.9, 3.0, 2.4, 2.8, 2.2];
    const afterIPL = [4.6, 4.3, 4.0, 3.8, 3.9, 3.3, 3.6, 2.9];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Before IPL',
                    data: beforeIPL,
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                },
                {
                    label: 'After IPL',
                    data: afterIPL,
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            scales: {
                x: {
                    stacked: false,
                    grid: {
                        display: false
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 5,
                    stepSize: 1,
                    title: {
                        display: true,
                        text: 'Consideration Score'
                    },
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export PNG
    // document.getElementById('exportBtn_q11').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'e1.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q11').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'e1.png');
    });

});

// Chart for F1
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq13').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'Ceat Tyres',
        'MY11Circle',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const yesData = [61, 44, 35, 39, 36, 28, 33, 25];
    const noData = [24, 30, 38, 36, 37, 42, 39, 49];
    const notSureData = [15, 26, 27, 25, 27, 30, 28, 26];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Yes (%)',
                    data: yesData,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No (%)',
                    data: noData,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not Sure (%)',
                    data: notSureData,
                    backgroundColor: 'rgba(201, 203, 207, 0.7)',
                    borderColor: 'rgba(201, 203, 207, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y', // Horizontal bars
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    },
                    grid: {
                        display: false
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export PNG
    // document.getElementById('exportBtn_q13').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'f1.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q13').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'f1.png');
    });

});

// Chart for F2
document.addEventListener("DOMContentLoaded", function () {
    const ctx = document.getElementById('chartq14').getContext('2d');

    const brandLabels = [
        'TATA',
        'RuPay',
        'MY11Circle',
        'Ceat Tyres',
        'TATA Neu',
        'Angel One',
        'TATA Curvv',
        'Wonder Cement'
    ];

    const yesData = [38.0, 31.0, 24.0, 16.0, 17.0, 14.0, 1.5, 12.0];
    const noData = [49, 54, 61, 70, 67, 72, 85, 73];
    const notSureData = [13.0, 15.0, 15.0, 14.0, 16.0, 14.0, 13.5, 15.0];

    const chartConfig = {
        type: 'bar',
        data: {
            labels: brandLabels,
            datasets: [
                {
                    label: 'Yes (%)',
                    data: yesData,
                    backgroundColor: 'rgba(75, 192, 192, 0.7)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                },
                {
                    label: 'No (%)',
                    data: noData,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Not Sure (%)',
                    data: notSureData,
                    backgroundColor: 'rgba(201, 203, 207, 0.7)',
                    borderColor: 'rgba(201, 203, 207, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: false,
            maintainAspectRatio: false,
            indexAxis: 'y', // Horizontal bars
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    max: 100,
                    title: {
                        display: true,
                        text: 'Percentage (%)'
                    },
                    grid: {
                        display: false
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                    callbacks: {
                        label: function (context) {
                            return `${context.dataset.label}: ${context.raw}%`;
                        }
                    }
                }
            }
        }
    };

    const chartInstance = new Chart(ctx, chartConfig);

    // Export PNG
    // document.getElementById('exportBtn_q14').addEventListener('click', function () {
    //     const imageUrl = chartInstance.toBase64Image();
    //     const link = document.createElement('a');
    //     link.href = imageUrl;
    //     link.download = 'f2.png';
    //     link.click();
    // });

    document.getElementById('exportBtn_q14').addEventListener('click', function (event) {
        exportChartAsPNG(event, 'f2.png');
    });

});



function exportChartAsPNG(event,filename) {
    const clickedButton = event.target;

    // Get the closest parent card-dashboard-map-one from the button
    const cardContainer = clickedButton.closest('.card-dashboard-map-one');

    // Hide the button before screenshot
    clickedButton.style.display = 'none';

    setTimeout(() => {
        html2canvas(cardContainer, {
            scale: 2,
            useCORS: true
        }).then(canvas => {
            // Show the button again
            clickedButton.style.display = 'inline-block';

            const link = document.createElement('a');
            link.download = filename;
            link.href = canvas.toDataURL();
            link.click();
        });
    }, 100);
}