// Call on page load
$(document).ready(function () {
    load_brands(function () {
        // Only call filter_data *after* brands are loaded
        filter_data();
    });

	$('.sumoselect2').SumoSelect();
});

function load_brands(callback) {
    $.ajax({
        url: 'api/brands.php', // API endpoint
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.brands) {
                var select = $('#select_brand'); // The select element
                select.empty(); // Clear existing options
                select.append('<option value="">All Brands</option>'); // Default option

                // Loop through the brands and append each one to the select box
                response.brands.forEach(function(brand) {
                    select.append('<option value="' + brand.value + '">' + brand.text + '</option>');
                });
                
                // Automatically select the first option
                select.prop('selectedIndex', 0);


                // Updates Matches
                var select = $('#select_match'); // The select element
                select.empty(); // Clear existing options

                // Loop through the brands and append each one to the select box
                response.matches.forEach(function(match) {
                    select.append('<option value="' + match.value + '" selected>' + match.text + '</option>');
                });               
                                
                // Re-initialize SumoSelect after updating options
                if (select.hasClass('SumoUnder')) {
                    select[0].sumo.unload(); // Unload the previous instance if needed
                }
                select.SumoSelect({ placeholder: 'Select options' });
                                
                // Updates Assets
                var select = $('#select_asset'); // The select element
                select.empty(); // Clear existing options
                select.append('<option value="">All Assets</option>'); // Default option

                // Loop through the brands and append each one to the select box
                response.assets.forEach(function(asset) {
                    select.append('<option value="' + asset.value + '">' + asset.text + '</option>');
                });
                
                // Automatically select the first option
                select.prop('selectedIndex', 0);


                // Call the callback after brands are loaded
                if (typeof callback === 'function') {
                    callback();
                }
            } else {
                console.log('Error: No brands found.');
            }

            if (response.match_dates) {
                $('#start_date').val(response.match_dates.min);
                $('#end_date').val(response.match_dates.max);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error: ' + status + ', ' + error);
        }
    });
}

function filter_data() {
    var sele_brand = $("#select_brand").val();
    var select_match = $("#select_match").val();
    var select_asset = $("#select_asset").val();
    var select_media = $("#select_media").val();
    var sele_start_date = $("#start_date").val();
    var sele_end_date = $("#end_date").val();

    if (!sele_brand || sele_brand.trim() === "") {
        $("#sponsor_eval").prop('selectedIndex', 0);
    }  

    refresh_screen(sele_brand,select_match,select_asset,select_media,sele_start_date,sele_end_date);
}

function refresh_screen(sele_brand="", select_match="", select_asset="", select_media="", sele_start_date="", sele_end_date="") {
    $('#global-loader').show();

    if(sele_brand=="") {
        $("#sponsor_eval").html("All Brands");    
        $("#sponsor_eval_pie").html("All Brands");    
    }
    else {
        $("#sponsor_eval").html(sele_brand);    
        $("#sponsor_eval_pie").html(sele_brand);    
    }

    load_bar_chart(sele_brand,select_match,select_asset,select_media,sele_start_date,sele_end_date);
    $('#global-loader').hide();
}

function load_bar_chart(sele_brand = "", select_match = "", select_asset = "", select_media = "", sele_start_date = "", sele_end_date = "") {
    $.ajax({
        url: 'api/comparison_chart.php',
        type: 'POST',
        dataType: 'json',
        data: {
            sele_brand: sele_brand,
            select_match: JSON.stringify(select_match),
            select_asset: select_asset,
            select_media: JSON.stringify(select_media),
            sele_start_date: sele_start_date,
            sele_end_date: sele_end_date
        },
        success: function (bardata) {
            const ctx3 = document.getElementById('comparison_chart').getContext('2d');

            // Clean up previous chart instance
            if (window.barChartInstance) {
                window.barChartInstance.destroy();
            }

            // Find the maximum value in the dataset (for Y-axis scaling)
            const maxValue = Math.max(...bardata.datasets.flatMap(dataset => dataset.data));
            const nextHighestValue = Math.ceil(maxValue * 1.1); // Increase by 10% to get the next value

            // Create gradient for the bars
            const gradient = ctx3.createLinearGradient(0, 0, 0, 250);
            gradient.addColorStop(0, '#285cf7');
            gradient.addColorStop(1, '#f7557a');

            // Apply gradient to each dataset if needed
            if (bardata.datasets && bardata.datasets.length > 0) {
                bardata.datasets.forEach(dataset => {
                    dataset.backgroundColor = gradient;
                });
            }

            // Create new bar chart
            window.barChartInstance = new Chart(ctx3, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            formatter: function (value) {
                                return value + ' Cr.';
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: nextHighestValue, // Set the max value of the Y axis to the next highest value
                            ticks: {
                                font: {
                                    size: 10
                                },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: {
                                display: false // Disable grid lines for Y axis
                            },
                            // Keep the base Y axis visible
                            borderColor: 'rgba(171, 167, 167,0.9)', // Color for the Y axis base line
                            borderWidth: 1 // Line width for the Y axis base
                        },
                        x: {
                            barPercentage: 0.6,
                            ticks: {
                                font: {
                                    size: 11
                                },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: {
                                display: false // Disable grid lines for X axis
                            },
                            // Keep the base X axis visible
                            borderColor: 'rgba(171, 167, 167,0.9)', // Color for the X axis base line
                            borderWidth: 1 // Line width for the X axis base
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            // Add event listener for the export button
            document.getElementById('exportBtn_barchart').addEventListener('click', function() {
                const imageUrl = window.barChartInstance.toBase64Image(); // Get chart as base64 PNG
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'chart.png'; // Default download filename
                link.click(); // Trigger the download
            });
        },
        error: function (xhr, status, error) {
            console.error("Bar chart load failed:", error);
        }
    });
}


