<?php
header('Content-Type: application/json');

include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Get filters from query string
    $sele_brand = isset($_REQUEST['sele_brand']) ? trim($_REQUEST['sele_brand']) : '';
    $select_match = isset($_REQUEST['select_match']) ? trim($_REQUEST['select_match']) : '';
    $select_asset = isset($_REQUEST['select_asset']) ? trim($_REQUEST['select_asset']) : '';
    $sele_start_date = isset($_REQUEST['sele_start_date']) ? trim($_REQUEST['sele_start_date']) : '';
    $sele_end_date = isset($_REQUEST['sele_end_date']) ? trim($_REQUEST['sele_end_date']) : '';

    // Start building query
    $sql = "
        SELECT 
            ROUND(SUM(net_tv_india)/10000000, 2) AS widget_1,
            ROUND(SUM(net_ott_india)/10000000, 2) AS widget_2,
            ROUND(SUM(net_tv_ott_row)/10000000, 2) AS widget_3,
            ROUND(SUM(print)/10000000, 2) AS widget_4,
            ROUND(SUM(social)/10000000, 2) AS widget_5
        FROM ipl_data
        WHERE 1=1
    ";

    // Build conditions
    $params = [];

    if (!empty($sele_brand)) {
        $sql .= " AND brand = :brand";
        $params['brand'] = $sele_brand;
    }
    if (!empty($select_match)) {
        $sql .= " AND match_name = :match";
        $params[':match'] = $select_match;
    }
    if (!empty($select_asset)) {
        $sql .= " AND location = :asset";
        $params[':asset'] = $select_asset;
    }
    if (!empty($sele_start_date)) {
        $sql .= " AND match_date >= :start_date";
        $params['start_date'] = $sele_start_date;
    }

    if (!empty($sele_end_date)) {
        $sql .= " AND match_date <= :end_date";
        $params['end_date'] = $sele_end_date;
    }

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    // Get Media Rate
    $rate_sql = "SELECT round(((sum(gross_tv_india) / sum(exposure_duration)) * 10)/100000,2) as nedia_rate from ipl_data WHERE 1=1 ";
    // Build conditions
    $rate_params = [];

    if (!empty($sele_brand)) {
        $rate_sql .= " AND brand = :brand";
        $rate_params['brand'] = $sele_brand;
    }

    if (!empty($select_match)) {
        $sql .= " AND match_name = :match";
        $params[':match'] = $select_match;
    }

    if (!empty($sele_start_date)) {
        $rate_sql .= " AND match_date >= :start_date";
        $rate_params['start_date'] = $sele_start_date;
    }

    if (!empty($sele_end_date)) {
        $rate_sql .= " AND match_date <= :end_date";
        $rate_params['end_date'] = $sele_end_date;
    }

    $rateStmt = $pdo->prepare($rate_sql);
    $rateStmt->execute($rate_params);
    $rateData = $rateStmt->fetch(PDO::FETCH_ASSOC);

    // Return result
    $response = [
        'widget_1' => $data['widget_1'] ?? 0,
        'widget_2' => $data['widget_2'] ?? 0,
        'widget_3' => $data['widget_3'] ?? 0,
        'widget_4' => $data['widget_4'] ?? 0,
        'widget_5' => $data['widget_5'] ?? 0,
        'widget_6' => ($data['widget_1'] ?? 0) + ($data['widget_2'] ?? 0) + ($data['widget_3'] ?? 0) + ($data['widget_4'] ?? 0) + ($data['widget_5'] ?? 0),
        'media_rate' => $rateData['nedia_rate']
    ];

    echo json_encode($response);

} catch (PDOException $e) {
    echo json_encode([
        'error' => true,
        'message' => 'DB Error: ' . $e->getMessage()
    ]);
}
