<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Build base query
    $sql = "
        SELECT 
            UPPER(ipl) AS label,
            ROUND(SUM(tv),2) AS tv_total,
            ROUND(SUM(ott),2) AS ott_total
        FROM ipl_reach
        GROUP BY 1
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare chart data
    $labels = [];
    $tvData = [];
    $ottData = [];

    foreach ($rows as $row) {
        $labels[] = $row['label'];
        $tvData[] = (float)$row['tv_total'];
        $ottData[] = (float)$row['ott_total'];
    }

    // Return JSON for Chart.js stacked bar
    echo json_encode([
        'labels' => $labels,
        'datasets' => [
            [
                'label' => 'TV',
                'data' => $tvData
            ],
            [
                'label' => 'OTT',
                'data' => $ottData
            ]
        ]
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
