<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Fetch comment from ipl_ratings
    $stmt1 = $pdo->prepare("
        SELECT comment 
        FROM ipl_ratings 
        WHERE comment IS NOT NULL AND comment != '' 
        LIMIT 1
    ");
    $stmt1->execute();
    $ratingResult = $stmt1->fetch(PDO::FETCH_ASSOC);
    $ratingComment = $ratingResult ? $ratingResult['comment'] : '';

    // Fetch comment from ipl_reach
    $stmt2 = $pdo->prepare("
        SELECT comment 
        FROM ipl_reach 
        WHERE comment IS NOT NULL AND comment != '' 
        LIMIT 1
    ");
    $stmt2->execute();
    $reachResult = $stmt2->fetch(PDO::FETCH_ASSOC);
    $reachComment = $reachResult ? $reachResult['comment'] : '';

    // Respond with both comments
    echo json_encode([
        'rating_comments' => $ratingComment,
        'reach_comments' => $reachComment
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
