<?php
header('Content-Type: application/json');

include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Get filters from query string
    $sele_brand = isset($_REQUEST['sele_brand']) ? trim($_REQUEST['sele_brand']) : '';
    $select_match = isset($_REQUEST['select_match']) ? trim($_REQUEST['select_match']) : '';
    $select_asset = isset($_REQUEST['select_asset']) ? trim($_REQUEST['select_asset']) : '';
    $sele_start_date = isset($_REQUEST['sele_start_date']) ? trim($_REQUEST['sele_start_date']) : '';
    $sele_end_date = isset($_REQUEST['sele_end_date']) ? trim($_REQUEST['sele_end_date']) : '';    

    // Base query
    $sql = "
        SELECT 
            location,
            TIME_FORMAT(SEC_TO_TIME(SUM(exposure_duration)), '%H:%i:%s') AS exposure_duration,
            ROUND(IFNULL(SUM(gross_tv_india), 0) / 10000000, 2) AS gross_tv_india,
            ROUND(IFNULL(SUM(net_tv_india), 0) / 10000000, 2) AS net_tv_india,
            ROUND(IFNULL(SUM(net_ott_india), 0) / 10000000, 2) AS net_ott_india,
            ROUND(IFNULL(SUM(net_tv_ott_row), 0) / 10000000, 2) AS net_tv_ott_row,
            ROUND(
                (IFNULL(SUM(net_tv_india), 0) / NULLIF(SUM(gross_tv_india), 0)) * 100,
                2
            ) AS discount_perc
        FROM ipl_data
        WHERE 1=1
    ";

    $params = [];

    // Apply filters dynamically
    if (!empty($sele_brand)) {
        $sql .= " AND brand = :brand";
        $params[':brand'] = $sele_brand;
    }

    if (!empty($select_match)) {
        $sql .= " AND match_name = :match";
        $params[':match'] = $select_match;
    }

    if (!empty($select_asset)) {
        $sql .= " AND location = :asset";
        $params[':asset'] = $select_asset;
    }

    if (!empty($sele_start_date)) {
        $sql .= " AND match_date >= :start_date";
        $params[':start_date'] = $sele_start_date;
    }

    if (!empty($sele_end_date)) {
        $sql .= " AND match_date <= :end_date";
        $params[':end_date'] = $sele_end_date;
    }

    // Grouping and sorting
    $sql .= " GROUP BY location ORDER BY 3 DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $data = $stmt->fetchAll();

    // file_put_contents("/var/www/html/ipl/test.txt",$sql);

    echo json_encode(['data' => $data]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
