<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Get filters from request
    $sele_brand = isset($_REQUEST['sele_brand']) ? trim($_REQUEST['sele_brand']) : '';
    $select_match = isset($_REQUEST['select_match']) ? json_decode($_REQUEST['select_match']) : [];
    $select_asset = isset($_REQUEST['select_asset']) ? trim($_REQUEST['select_asset']) : '';
    $select_media = isset($_REQUEST['select_media']) ? json_decode($_REQUEST['select_media']) : [];
    $sele_start_date = isset($_REQUEST['sele_start_date']) ? trim($_REQUEST['sele_start_date']) : '';
    $sele_end_date = isset($_REQUEST['sele_end_date']) ? trim($_REQUEST['sele_end_date']) : '';

    if (!empty($select_media)) {
        $select_columns = implode(" + ",$select_media);
    }
    else {
        $select_columns = "net_tv_india + net_ott_india + net_tv_ott_row + print + social";
    }

    // Build base query
    $sql = "
        SELECT 
            upper(match_name) AS label,
            ROUND(SUM(". $select_columns .")/10000000, 0) AS net_total
        FROM ipl_data
        WHERE 1=1
    ";

    $params = [];

    // Apply filters
    if (!empty($sele_brand)) {
        $sql .= " AND brand = :brand";
        $params['brand'] = $sele_brand;
    }
    if (!empty($select_match)) {
        $sql .= ' AND match_name in ("'. implode('","',$select_match) .'")';
    }
    if (!empty($select_asset)) {
        $sql .= " AND location = :asset";
        $params[':asset'] = $select_asset;
    }    
    if (!empty($sele_start_date)) {
        $sql .= " AND match_date >= :start_date";
        $params['start_date'] = $sele_start_date;
    }
    if (!empty($sele_end_date)) {
        $sql .= " AND match_date <= :end_date";
        $params['end_date'] = $sele_end_date;
    }

    $sql .= " GROUP BY 1";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare chart data
    $labels = [];
    $totals = [];

    foreach ($rows as $row) {
        $labels[] = $row['label'];
        $totals[] = (float)$row['net_total'];
    }

    // Return JSON for Chart.js
    echo json_encode([
        'labels' => $labels,
        'datasets' => [
            [
                'label' => 'TOTAL NET SPONSORSHIP in Cr.',
                'data' => $totals
            ]
        ]
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
