<?php
declare(strict_types=1);

$configAll = parse_ini_file(__DIR__ . "/db.ini", true);
if (!$configAll || !isset($configAll['mysql'])) {
    http_response_code(500);
    die("Invalid db.ini (need [mysql])");
}
$config = $configAll['mysql'];

$host = $config['host'] ?? 'localhost';
$user = $config['user'] ?? '';
$pass = $config['password'] ?? '';
$db   = $config['database'] ?? '';
$port = isset($config['port']) ? (int)$config['port'] : 3306;

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    die("DB connection failed");
}
$conn->set_charset("utf8mb4");
