<?php
include_once("header.php");
include_once("menu.php");
?>

<!-- main-content -->
<div class="main-content app-content">
	<!-- container -->
	<div class="main-container container-fluid">    
		<!-- breadcrumb -->
		<div class="breadcrumb-header justify-content-between">
			<div class="left-content">
				<div>
				<h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1">USERS</h2>
				</div>
			</div>
			<div class="main-dashboard-header-right">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">Add User</button>
			</div>
		</div>
		<!-- breadcrumb -->


		<!-- row opened -->
		<div class="row row-sm align-items-stretch">
			<div class="col-lg-12 col-xl-12 d-flex">
				<div class="card card-dashboard-map-one w-100">
                    <div class="card-body" style="padding: 1px !important;">
                        <div class="table-responsive">
                            <table class="table border-top-0 table-bordered text-nowrap border-bottom" id="user-datatable">
                                <thead>
                                    <tr>
                                        <th class="wd-45p border-bottom-0" style="background-color: #999;">User Name</th>
                                        <th class="wd-45p border-bottom-0" style="background-color: #999;">Team</th>
                                        <th class="wd-10p border-bottom-0" style="background-color: #999;">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
				</div>
			</div>
		</div>
    </div>
</div>
<!-- /main-content -->

<!-- Edit Modal -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="editUserForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editUserModalLabel">Edit User</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <input type="hidden" id="user_id" name="user_id" />
            <div class="mb-3">
                <label for="email" class="form-label">User Name</label>
                <input type="text" class="form-control" id="email" name="email" required  style="color: #000;">
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" minlength="6">
            </div>
            <div class="mb-3">
                <label for="team" class="form-label">Team</label>
                <input type="text" class="form-control" id="team" name="team"  style="color: #000;">
            </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUserModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="addUserForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addUserModalLabel">Add User</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <input type="hidden" id="user_id" name="user_id" />
            <div class="mb-3">
                <label for="email" class="form-label">User Name</label>
                <input type="text" class="form-control" id="email" name="email" required  style="color: #000;">
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" minlength="6" required>
            </div>
            <div class="mb-3">
                <label for="team" class="form-label">Team</label>
                <input type="text" class="form-control" id="team" name="team"  style="color: #000;">
            </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </form>
  </div>
</div>

<?php
include_once("footer.php");
?>

<script src="assets/js/user.js?cache=<?php echo date("YmdHis") . rand(1,10000); ?>"></script>