
$(document).ready(function() {
    $('#user-datatable').DataTable({
        language: {
            searchPlaceholder: 'Search...',
            scrollX: "100%",
            sSearch: '',
        }
    });

    loadUsers();

    // Handle edit button click
    $(document).on('click', '.edit-btn', function () {
        var row = $(this).closest('tr');
        var userId = row.data('id');
        var email = row.data('email');
        var team = row.data('team');

        $('#user_id').val(userId);
        $('#email').val(email);
        $('#team').val(team);
        $('#password').val(''); // Clear previous password

        var editModal = new bootstrap.Modal(document.getElementById('editUserModal'));
        editModal.show();
    });

    // Handle form submit
    $('#editUserForm').on('submit', function (e) {
        e.preventDefault();

        const userId = $('#user_id').val();
        const email = $('#email').val();
        const team = $('#team').val();

        $.ajax({
            url: 'api/update_user.php',
            method: 'POST',
            data: $(this).serialize(),
            success: function (response) {
                if (response === 'success') {
                    $('#editUserModal').modal('hide');

                    const row = $('#user-datatable tbody tr').filter(function () {
                        return $(this).data('id') == userId;
                    });

                    row.find('td:eq(0)').text(email);
                    row.find('td:eq(1)').text(team);

                    // Update data attributes
                    row.data('email', email);
                    row.data('team', team);

                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'User updated successfully!',
                        timer: 1500,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'Failed to update user!'
                    });
                }
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Error occurred while updating user.'
                });
            }
        });
    });

    // Handle delete button click
    $(document).on('click', '.delete-btn', function () {
        const row = $(this).closest('tr');
        const userId = row.data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: "This user will be permanently deleted!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'api/delete_user.php',
                    method: 'POST',
                    data: { user_id: userId },
                    success: function (response) {
                        if (response === 'success') {
                            row.remove();

                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: 'User has been deleted.',
                                timer: 1500,
                                showConfirmButton: false
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Failed',
                                text: 'Could not delete the user.'
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Something went wrong while deleting the user.'
                        });
                    }
                });
            }
        });
    });

    // Handle Add User form submit
    $('#addUserForm').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: 'api/add_user.php', // You’ll need to create this
            method: 'POST',
            data: $(this).serialize(),
            success: function (response) {
                if (response === 'success') {
                    $('#addUserModal').modal('hide');
                    Swal.fire({
                        icon: 'success',
                        title: 'User added successfully!',
                        timer: 1500,
                        showConfirmButton: false
                    });
                    loadUsers(); // Reload table
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'Failed to add user!'
                    });
                }
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Error occurred while adding user.'
                });
            }
        });
    });

    // Show Add User Modal and clear form fields
    $('[data-bs-target="#addUserModal"]').on('click', function () {
        // Clear form fields
        $('#addUserForm')[0].reset();

        // Optional: focus on the first input
        $('#addUserModal #email').focus();
    });

});

function loadUsers() {
    $.ajax({
        url: 'api/load_users.php',
        method: 'GET',
        success: function (response) {
            if (response.status === 'success') {
                const table = $('#user-datatable').DataTable();
                table.clear().destroy(); // Destroy old instance

                const tbody = $('#user-datatable tbody');
                tbody.empty();

                response.data.forEach(user => {
                    const row = `
                        <tr data-id="${user.id}" data-email="${user.email}" data-team="${user.teams}">
                            <td>${user.email}</td>
                            <td>${user.teams}</td>
                            <td>
                                <button class="btn btn-sm btn-primary me-1 edit-btn">Edit</button>
                                <button class="btn btn-sm btn-danger delete-btn">Delete</button>
                            </td>
                        </tr>
                    `;
                    tbody.append(row);
                });

                // Reinitialize DataTable after loading new data
                $('#user-datatable').DataTable({
                    language: {
                        searchPlaceholder: 'Search...',
                        scrollX: "100%",
                        sSearch: '',
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Oops!',
                    text: 'Failed to load users'
                });
            }
        },
        error: function () {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error fetching user data'
            });
        }
    });
}


