<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    if (!isset($_POST['user_id']) || !isset($_POST['email']) || !isset($_POST['team'])) {
        echo json_encode(['error' => 'Missing required fields']);
        exit;
    }

    $user_id = (int) $_POST['user_id'];
    $email = trim($_POST['email']);
    $team = trim($_POST['team']);
    $password = isset($_POST['password']) ? trim($_POST['password']) : null;

    $pdo = new PDO($dsn, $user, $pass, $options);

    $sql = "UPDATE users SET email = :email, teams = :team";
    if (!empty($password)) {
        $sql .= ", password = :password";
    }
    $sql .= " WHERE id = :user_id";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':team', $team);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

    if (!empty($password)) {
        $md5Password = md5($password);
        $stmt->bindParam(':password', $md5Password);
    }

    $stmt->execute();

    echo json_encode('success');

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
