<?php
session_start();

include_once('db.php');

$pdo = new PDO($dsn, $user, $pass, $options);

// Step 1: Fetch `ipl_teams` for the logged-in user
$teamsCondition = ' 1=1 '; // default

if (!empty($_SESSION['ipl_user_id'])) {
    $userId = $_SESSION['ipl_user_id'];

    $stmt = $pdo->prepare("SELECT teams FROM users WHERE id = :user_id");
    file_put_contents('log.txt', "SELECT teams FROM users WHERE id = :user_id");
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && !empty($result['teams'])) {
        // Step 2: Convert string to array, sanitize
        $teamsArray = array_map('trim', explode(',', $result['teams']));
        $teamsArray = array_filter($teamsArray); // remove empty values

        // Step 3: Prepare for SQL IN clause
        if (!empty($teamsArray)) {
            // Quote each team name to prevent SQL injection
            $quotedTeams = array_map(function ($team) use ($pdo) {
                return $pdo->quote($team);
            }, $teamsArray);

            $teamsCondition = ' team IN (' . implode(',', $quotedTeams) . ') ';
        }
    }
}
