<?php
header('Content-Type: application/json');

$uploadDir = '../csv/';
$response = [];

include_once('db.php');

// Currency cleaner function
function cleanCurrency($value) {
	$value = preg_replace('/[₹,\s]/u', '', $value);
	return is_numeric($value) ? (float)$value : 0.0;
}

function stingToDate($dateString) {
	$date = DateTime::createFromFormat('d-M-y', $dateString);
	return $date ? $date->format('Y-m-d') : "0000-00-00";
}

try {
	$pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
	echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
	exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if (isset($_FILES['importSponsorshipFormCsvFile']) && $_FILES['importSponsorshipFormCsvFile']['error'] === UPLOAD_ERR_OK) {
		$fileTmpPath = $_FILES['importSponsorshipFormCsvFile']['tmp_name'];
		$fileName = $_FILES['importSponsorshipFormCsvFile']['name'];
		$fileNameCmps = explode(".", $fileName);
		$fileExtension = strtolower(end($fileNameCmps));

		$allowedExtensions = ['csv'];

		if (in_array($fileExtension, $allowedExtensions)) {
			$newFileName = 'data_' . date('YmdHis') . '.' . $fileExtension;
			$destPath = $uploadDir . $newFileName;

			if (move_uploaded_file($fileTmpPath, $destPath)) {

				// try {
				// 	$pdo->exec("TRUNCATE TABLE ipl_data");
				// } catch (PDOException $e) {
				// 	echo json_encode(['status' => 'error', 'message' => 'Failed to truncate table: ' . $e->getMessage()]);
				// 	exit;
				// }

				if (($handle = fopen($destPath, "r")) !== false) {
					$headers = fgetcsv($handle);

					// Check and remove BOM (Byte Order Mark) if it exists
					foreach ($headers as &$header) {
						// Remove BOM (if exists) at the beginning of the header
						$header = preg_replace('/^\xEF\xBB\xBF/', '', $header); // Remove BOM
						
						// Trim any extra spaces from the headers
						$header = trim($header);
					}

					$headers = array_map('trim', $headers); // trim extra spaces
					$rowCount = 0;

					// Map columns
					$colMap = [
						'Location'   => null,
						'Exposure'   => null,
						'Brands'     => null,
						'GrossTV'    => null,
						'NetTV'      => null,
						'NetOTT'     => null,
						'ROW'     	 => null,
						'AIS%'       => null,
						'Print'      => null,
						'Social'     => null,
						'Date'       => null,
						'Match'      => null,
						'Team'      => null,
					];

					foreach ($colMap as $key => $value) {
						$index = array_search($key, $headers);
						if ($index !== false) {
							$colMap[$key] = $index;
						} else {
							$response = ['status' => 'error', 'message' => "Missing column: $key","Headers" => $headers];
							echo json_encode($response);
							exit;
						}
					}

					$sql = "INSERT IGNORE INTO ipl_data (
								location,
								exposure_duration,
								brand,
								gross_tv_india,
								net_tv_india,
								net_ott_india,
								net_tv_ott_row,
								discount_perc,
								print,
								social,
								match_date,
								match_name,
								team
							) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							
					$stmt = $pdo->prepare($sql);

					while (($data = fgetcsv($handle, 1000, ",")) !== false) {
						if (count($data) < count($headers)) continue;

						$exposure = str_replace(",", "", $data[$colMap['Exposure']]);


						$stmt->execute([
							$data[$colMap['Location']],
							(float) $exposure,
							$data[$colMap['Brands']],
							cleanCurrency($data[$colMap['GrossTV']]),
							cleanCurrency($data[$colMap['NetTV']]),
							cleanCurrency($data[$colMap['NetOTT']]),
							cleanCurrency($data[$colMap['ROW']]),
							(float) $data[$colMap['AIS%']],
							cleanCurrency($data[$colMap['Print']]),
							cleanCurrency($data[$colMap['Social']]),
							stingToDate($data[$colMap['Date']]),
							$data[$colMap['Match']],
							$data[$colMap['Team']],
						]);

						$rowCount++;
					}

					fclose($handle);

					$response = [
						'status' => 'success',
						'message' => "File uploaded and $rowCount rows imported.",
						'fileName' => $newFileName
					];
				} else {
					$response = ['status' => 'error', 'message' => 'Failed to read the uploaded CSV file.'];
				}
			} else {
				$response = ['status' => 'error', 'message' => 'Error moving uploaded file.'];
			}
		} else {
			$response = ['status' => 'error', 'message' => 'Invalid file type. Only .csv allowed.'];
		}
	} else {
		$response = ['status' => 'error', 'message' => 'No file uploaded or upload error.'];
	}
} else {
	$response = ['status' => 'error', 'message' => 'Invalid request method.'];
}

echo json_encode($response);
?>
