<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    if (!isset($_POST['user_id'])) {
        echo json_encode('error');
        exit;
    }

    $user_id = (int)$_POST['user_id'];

    $pdo = new PDO($dsn, $user, $pass, $options);

    $stmt = $pdo->prepare("DELETE FROM users WHERE id = :id");
    $stmt->bindParam(':id', $user_id, PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode('success');
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
