<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    // Validate required fields
    if (!isset($_POST['email']) || !isset($_POST['password']) || !isset($_POST['team'])) {
        echo json_encode('error');
        exit;
    }

    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $team = trim($_POST['team']);

    if (empty($email) || empty($password)) {
        echo json_encode('error');
        exit;
    }

    // Hash password using MD5 (as per your previous request — not recommended for production)
    $hashedPassword = md5($password);

    $pdo = new PDO($dsn, $user, $pass, $options);

    $stmt = $pdo->prepare("INSERT INTO users (email, password, teams) VALUES (:email, :password, :team)");
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':password', $hashedPassword);
    $stmt->bindParam(':team', $team);

    $stmt->execute();

    echo json_encode('success');

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
