function load_brands(callback) {
    $.ajax({
        url: 'api/brands.php', // API endpoint
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.brands) {
                var select = $('#select_brand'); // The select element
                select.empty(); // Clear existing options
                select.append('<option value="">All Brands</option>'); // Default option

                // Loop through the brands and append each one to the select box
                response.brands.forEach(function(brand) {
                    select.append('<option value="' + brand.value + '">' + brand.text + '</option>');
                });
                
                // Automatically select the first option
                select.prop('selectedIndex', 0);

                // Updates Matches
                var select = $('#select_match'); // The select element
                select.empty(); // Clear existing options

                // Loop through the brands and append each one to the select box
                response.matches.forEach(function(match) {
                    select.append('<option value="' + match.value + '" selected>' + match.text + '</option>');
                });    
                
                // Updates Assets
                var select = $('#select_asset'); // The select element
                select.empty(); // Clear existing options
                select.append('<option value="">All Assets</option>'); // Default option

                // Loop through the brands and append each one to the select box
                response.assets.forEach(function(asset) {
                    select.append('<option value="' + asset.value + '">' + asset.text + '</option>');
                });
                
                // Automatically select the first option
                select.prop('selectedIndex', 0);


                // Call the callback after brands are loaded
                if (typeof callback === 'function') {
                    callback();
                }
            } else {
                console.log('Error: No brands found.');
            }

            if (response.match_dates) {
                $('#start_date').val(response.match_dates.min);
                $('#end_date').val(response.match_dates.max);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error: ' + status + ', ' + error);
        }
    });
}

function loadWidgets(sele_brand = "", select_match="", select_asset="", sele_start_date = "", sele_end_date = "") {
	$.ajax({
		url: 'api/widgets.php',
		type: 'POST',
		dataType: 'json',
		data: {
			sele_brand: sele_brand,
			select_match: select_match,
            select_asset: select_asset,
			sele_start_date: sele_start_date,
			sele_end_date: sele_end_date
		},
		success: function (data) {
			$('#widget_1').text('₹' + parseFloat(data.widget_1).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#widget_2').text('₹' + parseFloat(data.widget_2).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#widget_3').text('₹' + parseFloat(data.widget_3).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#widget_4').text('₹' + parseFloat(data.widget_4).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#widget_5').text('₹' + parseFloat(data.widget_5).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#widget_6').text('₹' + parseFloat(data.widget_6).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#pie_chart_widget_value').text('₹' + parseFloat(data.widget_6).toLocaleString(undefined, { minimumFractionDigits: 2 }));
			$('#media_rate').text(data.media_rate);
		},
		error: function (xhr, status, error) {
			console.error('Failed to load widgets:', error);
		}
	});
}

function load_pie_chart(sele_brand = "", select_match = "", select_asset = "", sele_start_date = "", sele_end_date = "") {

	$.ajax({
		url: 'api/piechart.php',
		type: 'POST',
        dataType: 'json',
        data: {
			sele_brand: sele_brand,
            select_match: select_match,
            select_asset: select_asset,
			sele_start_date: sele_start_date,
			sele_end_date: sele_end_date
		},
		success: function (piedata) {
			// Initialize the pie chart
			$.plot('#flotPie2', piedata, {
				series: {
					pie: {
						show: true,
						radius: 1,
						innerRadius: 0.5,
						label: {
							show: true,
							radius: 2 / 3,
							formatter: labelFormatter,
							threshold: 0.1
						}
					}
				},
				legend: {
					show: false
				},
				grid: {
					borderWidth: 1,
					borderColor: 'rgba(171, 167, 167,0.2)',
					hoverable: true
				}
			});

            // Add event listener for the export button
            document.getElementById('exportBtn_piechart').addEventListener('click', function() {
                // Capture the pie chart using html2canvas (callback version)
                html2canvas(document.querySelector("#flotPie2"), {
                    onrendered: function(canvas) {
                        // Create an image from the canvas
                        const imageUrl = canvas.toDataURL("image/png"); // Convert to PNG
                        const link = document.createElement('a');
                        link.href = imageUrl;
                        link.download = 'pie_chart.png'; // Default download filename
                        link.click(); // Trigger the download
                    }
                });
            });
		},
		error: function (xhr, status, error) {
			console.error("Pie chart load failed:", error);
		}
	});

	// Label formatter function for pie chart
	function labelFormatter(label, series) {
		return '<div style="font-size:8pt; text-align:center; padding:2px; color:white;">' +
			label + '<br/>' + Math.round(series.percent) + '%</div>';
	}
}

function load_bar_chart(sele_brand = "", select_match = "", select_asset = "", sele_start_date = "", sele_end_date = "") {
    $.ajax({
        url: 'api/barchart.php',
        type: 'POST',
        dataType: 'json',
        data: {
            sele_brand: sele_brand,
            select_match: select_match,
            select_asset: select_asset,
            sele_start_date: sele_start_date,
            sele_end_date: sele_end_date
        },
        success: function (bardata) {
            const ctx3 = document.getElementById('brand_chart').getContext('2d');

            // Clean up previous chart instance
            if (window.barChartInstance) {
                window.barChartInstance.destroy();
            }

            // Create gradient for the bars
            const gradient = ctx3.createLinearGradient(0, 0, 0, 250);
            gradient.addColorStop(0, '#285cf7');
            gradient.addColorStop(1, '#f7557a');

            // Apply gradient to each dataset if needed
            if (bardata.datasets && bardata.datasets.length > 0) {
                bardata.datasets.forEach(dataset => {
                    dataset.backgroundColor = gradient;
                });
            }

            // Calculate the highest value in the data and add a buffer
            const maxValue = Math.max(...bardata.datasets[0].data);
            const maxYValue = Math.ceil(maxValue * 1.1);  // Add 10% buffer to the max value

            // Create new bar chart
            window.barChartInstance = new Chart(ctx3, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            formatter: function (value) {
                                return value + ' Cr.';
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: maxYValue,  // Set the maximum Y value to the calculated maxYValue
                            ticks: {
                                font: {
                                    size: 10
                                },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: {
                                display: false // Hide the grid lines
                            },
                            // Keep the base Y axis visible
                            borderColor: 'rgba(171, 167, 167,0.9)', // Color for the Y axis base line
                            borderWidth: 1 // Line width for the Y axis base
                        },
                        x: {
                            barPercentage: 0.6,
                            ticks: {
                                font: {
                                    size: 11
                                },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: {
                                display: false // Hide the grid lines
                            },
                            // Keep the base X axis visible
                            borderColor: 'rgba(171, 167, 167,0.9)', // Color for the X axis base line
                            borderWidth: 1 // Line width for the X axis base
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            // Add event listener for the export button
            document.getElementById('exportBtn_barchart').addEventListener('click', function() {
                const imageUrl = window.barChartInstance.toBase64Image(); // Get chart as base64 PNG
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'chart.png'; // Default download filename
                link.click(); // Trigger the download
            });
        },
        error: function (xhr, status, error) {
            console.error("Bar chart load failed:", error);
        }
    });
}

function load_table(sele_brand="", select_match="", select_asset="", sele_start_date="", sele_end_date="") {
    $('#datametrics-table').DataTable({
        ajax: {
            url: 'api/fetchdata.php',
            data: function(d) {
                d.sele_brand = sele_brand;
                d.select_match = select_match;
                d.select_asset = select_asset;
                d.sele_start_date = sele_start_date;
                d.sele_end_date = sele_end_date;
            },            
            dataSrc: 'data'
        },
        columns: [
            { data: 'location', className: 'text-start' },
            { data: 'exposure_duration', className: 'text-center' },
        
            { 
                data: 'gross_tv_india', 
                className: 'text-center',
                render: function (data) {
                    return '₹ ' + parseFloat(data).toLocaleString(undefined, { minimumFractionDigits: 2 }) + ' Cr';
                }
            },
            { 
                data: 'net_tv_india', 
                className: 'text-center',
                render: function (data) {
                    return '₹ ' + parseFloat(data).toLocaleString(undefined, { minimumFractionDigits: 2 }) + ' Cr';
                }
            },
            { 
                data: 'net_ott_india', 
                className: 'text-center',
                render: function (data) {
                    return '₹ ' + parseFloat(data).toLocaleString(undefined, { minimumFractionDigits: 2 }) + ' Cr';
                }
            },
            { 
                data: 'net_tv_ott_row', 
                className: 'text-center',
                render: function (data) {
                    return '₹ ' + parseFloat(data).toLocaleString(undefined, { minimumFractionDigits: 2 }) + ' Cr';
                }
            },
        
            { 
                data: 'discount_perc', 
                className: 'text-center',
                render: function (data) {
                    return data.toFixed(2) + ' %';
                }
            }
        ],        
        // order: [[3, 'desc']],
        order: [],
        destroy: true, // allows re-initialization
        scrollX: "100%",
        searching: false,
        lengthChange: false,
        info: false,
        responsive: true,
        language: {
            emptyTable: "No data available"
        },
        columnDefs: [
            {
                targets: 1, // column index for exposure_duration
                createdCell: function (td, cellData, rowData, row, col) {
                    $(td).css('text-align', 'center');
                }
            }
        ]
    });
}

function refresh_screen(sele_brand="", select_match="", select_asset="", sele_start_date="", sele_end_date="") {
    $('#global-loader').show();

    if(sele_brand=="") {
        $("#sponsor_eval").html("All Brands");    
        $("#sponsor_eval_pie").html("All Brands");    
    }
    else {
        $("#sponsor_eval").html(sele_brand);    
        $("#sponsor_eval_pie").html(sele_brand);    
    }

    loadWidgets(sele_brand,select_match,select_asset,sele_start_date,sele_end_date);
    load_pie_chart(sele_brand,select_match,select_asset,sele_start_date,sele_end_date);
    load_table(sele_brand,select_match,select_asset,sele_start_date,sele_end_date);
    load_bar_chart(sele_brand,select_match,select_asset,sele_start_date,sele_end_date);
    $('#global-loader').hide();
}

function importData() {
    var formData = new FormData($('#importForm')[0]);
    var importBtn = $('#importButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importModal').modal('hide');
                        alertBox.hide();
                        // window.location.reload();
                        load_brands(function () {
                            // Only call filter_data *after* brands are loaded
                            filter_data();
                        });
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}

// Call on page load
$(document).ready(function () {
    load_brands(function () {
        // Only call filter_data *after* brands are loaded
        filter_data();
    });


    $('.select2').select2();
    // Prevent dropdown from closing when clicking inside the form
    $('.dropdown-menu').on('click', function (e) {
        e.stopPropagation();
    });
    // Optional: Force height recalculation on select/unselect
    $('.select2').on('select2:select select2:unselect', function (e) {
        $(this).trigger('change.select2');
    });    
});


function filter_data() {

    var sele_brand = $("#select_brand").val();
    var select_match = JSON.stringify($("#select_match").val());
    var select_asset = $("#select_asset").val();
    var sele_start_date = $("#start_date").val();
    var sele_end_date = $("#end_date").val();
    
    if (!sele_brand || sele_brand.trim() === "") {
        $("#sponsor_eval").prop('selectedIndex', 0);
    }  

    refresh_screen(sele_brand,select_match,select_asset,sele_start_date,sele_end_date);
}