$(document).ready(function () {
    $('#importButton').on('click', function () {
        importData();
    });

    $('#closeButton').on('click', function () {
        $('#importModal').modal('hide');
        $('#importAlert').hide();
    });

    $('#importModal').on('show.bs.modal', function () {
        $('#importForm')[0].reset();
        $('#importAlert').hide();
    });  

    $('#changePasswordForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
        currentPassword: $('#currentPassword').val(),
        newPassword: $('#newPassword').val(),
        confirmPassword: $('#confirmPassword').val()
        };

        $.post('api/changepassword.php', formData, function (response) {
        const alertBox = $('#passwordChangeAlert');
        alertBox.removeClass('d-none alert-success alert-danger');

        if (response.status === 'success') {
            alertBox.addClass('alert-success').text(response.message);
            setTimeout(() => {
            $('#changePasswordModal').modal('hide');
            $('#changePasswordForm')[0].reset();
            alertBox.addClass('d-none');
            }, 2000);
        } else {
            alertBox.addClass('alert-danger').text(response.message);
        }
        }, 'json').fail(function () {
        const alertBox = $('#passwordChangeAlert');
        alertBox.removeClass('d-none alert-success').addClass('alert-danger').text('Something went wrong. Please try again.');
        });
    });
});

// Function to call the filter_data and toggle the div visibility
function refreshFilters() {
    // Call your filter_data function
    filter_data();

    // Toggle visibility of the dropdown menu
    $('#filter_button').click();
}