<?php
header('Content-Type: application/json');

include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Get filters from query string
    $sele_brand = isset($_REQUEST['sele_brand']) ? trim($_REQUEST['sele_brand']) : '';
    $select_match = isset($_REQUEST['select_match']) ? json_decode($_REQUEST['select_match']) : [];
    $select_asset = isset($_REQUEST['select_asset']) ? trim($_REQUEST['select_asset']) : '';
    $sele_start_date = isset($_REQUEST['sele_start_date']) ? trim($_REQUEST['sele_start_date']) : '';
    $sele_end_date = isset($_REQUEST['sele_end_date']) ? trim($_REQUEST['sele_end_date']) : '';    

    // Build base query
    $sql = "
        SELECT 
            ROUND(SUM(net_tv_india), 0) AS net_tv_india,
            ROUND(SUM(net_ott_india), 0) AS net_ott_india,
            ROUND(SUM(net_tv_ott_row), 0) AS net_tv_ott_row,
            ROUND(SUM(print), 0) AS print,
            ROUND(SUM(social), 0) AS social
        FROM ipl_data
        WHERE 1=1
    ";

    $params = [];

    // Add filters conditionally (✅ no colon in array keys)
    if (!empty($sele_brand)) {
        $sql .= " AND brand = :brand";
        $params['brand'] = $sele_brand;
    }
    if (!empty($select_match)) {
        $sql .= ' AND match_name in ("'. implode('","',$select_match) .'")';
    }
    if (!empty($select_asset)) {
        $sql .= " AND location = :asset";
        $params[':asset'] = $select_asset;
    }
    if (!empty($sele_start_date)) {
        $sql .= " AND match_date >= :start_date";
        $params['start_date'] = $sele_start_date;
    }
    if (!empty($sele_end_date)) {
        $sql .= " AND match_date <= :end_date";
        $params['end_date'] = $sele_end_date;
    }

    // Prepare and execute
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Build pie data array
    $colors = ['#ed1a23', '#f5767b', '#1c45a1', '#4ea6dc', '#494c57', '#00cccc', '#ffc107', '#dc3545'];
    $pieData = [];

    $pieData[] = [
        'label' => "TV India",
        'data' => [[1, (int)($row['net_tv_india'] ?? 0)]],
        'color' => $colors[0]
    ];
    $pieData[] = [
        'label' => "OTT India",
        'data' => [[1, (int)($row['net_ott_india'] ?? 0)]],
        'color' => $colors[1]
    ];
    // $pieData[] = [
    //     'label' => "TV OTT RoW",
    //     'data' => [[1, (int)($row['net_tv_ott_row'] ?? 0)]],
    //     'color' => $colors[5]
    // ];
    $pieData[] = [
        'label' => "Print",
        'data' => [[1, (int)($row['print'] ?? 0)]],
        'color' => $colors[2]
    ];
    $pieData[] = [
        'label' => "Social",
        'data' => [[1, (int)($row['social'] ?? 0)]],
        'color' => $colors[3]
    ];

    echo json_encode($pieData);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
