// Call on page load
$(document).ready(function () {
    refresh_screen();
});

function refresh_screen() {
    load_ratings_chart();
    load_reach_chart();
    load_match_ratings();
    get_comments();
}

function load_ratings_chart() {
    $.ajax({
        url: 'api/rating_chart.php',
        type: 'POST',
        dataType: 'json',
        success: function (bardata) {
            const ctx1 = document.getElementById('tv_ratings').getContext('2d');

            // Clean up previous chart instance
            if (window.ratingsChartInstance) {
                window.ratingsChartInstance.destroy();
            }

            const maxValue = Math.max(...bardata.datasets.flatMap(dataset => dataset.data));
            const nextHighestValue = Math.ceil(maxValue * 1.1);

            const gradient = ctx1.createLinearGradient(0, 0, 0, 250);
            gradient.addColorStop(0, '#285cf7');
            gradient.addColorStop(1, '#f7557a');

            if (bardata.datasets && bardata.datasets.length > 0) {
                bardata.datasets.forEach(dataset => {
                    dataset.backgroundColor = gradient;
                });
            }

            window.ratingsChartInstance = new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            formatter: value => value
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: nextHighestValue,
                            ticks: {
                                font: { size: 10 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        },
                        x: {
                            barPercentage: 0.6,
                            ticks: {
                                font: { size: 11 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            document.getElementById('exportBtn_barchart1').addEventListener('click', function () {
                const imageUrl = window.ratingsChartInstance.toBase64Image();
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'ratings_chart.png';
                link.click();
            });
        },
        error: function (xhr, status, error) {
            console.error("Rating chart load failed:", error);
        }
    });
}

function load_reach_chart() {
    $.ajax({
        url: 'api/reach_chart.php',
        type: 'POST',
        dataType: 'json',
        success: function (bardata) {
            const ctx2 = document.getElementById('tv_reach').getContext('2d');

            if (window.reachChartInstance) {
                window.reachChartInstance.destroy();
            }

            const maxStacked = bardata.labels.map((_, i) =>
                bardata.datasets.reduce((sum, dataset) => sum + dataset.data[i], 0)
            );
            const maxValue = Math.max(...maxStacked);
            const nextHighestValue = Math.ceil(maxValue * 1.1);

            const gradientTV = ctx2.createLinearGradient(0, 0, 0, 250);
            gradientTV.addColorStop(0, '#285cf7');
            gradientTV.addColorStop(1, '#3c9cd4');
            
            const gradientOTT = ctx2.createLinearGradient(0, 0, 0, 250);
            gradientOTT.addColorStop(0, '#f7557a');
            gradientOTT.addColorStop(1, '#fa8e63');
            
            if (bardata.datasets.length > 0) {
                bardata.datasets[0].backgroundColor = '#ed1c24'; // TV_total
                bardata.datasets[1].backgroundColor = '#f4777c'; // OTT_total
            }


            window.reachChartInstance = new Chart(ctx2, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top'
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            formatter: function (value) {
                                if(value >0) {
                                    return value + ' m';
                                }
                                else {
                                    return '';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            stacked: true,
                            max: nextHighestValue,
                            ticks: {
                                font: { size: 10 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        },
                        x: {
                            stacked: true,
                            barPercentage: 0.6,
                            ticks: {
                                font: { size: 11 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            document.getElementById('exportBtn_barchart2').addEventListener('click', function () {
                const imageUrl = window.reachChartInstance.toBase64Image();
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'reach_chart.png';
                link.click();
            });
        },
        error: function (xhr, status, error) {
            console.error("Reach chart load failed:", error);
        }
    });
}

function load_match_ratings() {
    load_match_rating_top();
    load_match_rating_bottom()
}

function load_match_rating_top() {
    $.ajax({
        url: 'api/match_rating_chart_top.php',
        type: 'POST',
        dataType: 'json',
        success: function (bardata) {
            const ctx1 = document.getElementById('tv_match_ratings_top').getContext('2d');

            // Clean up previous chart instance
            if (window.matchRatingTopChartInstance) {
                window.matchRatingTopChartInstance.destroy();
            }

            const maxValue = Math.max(...bardata.datasets.flatMap(dataset => dataset.data));
            const nextHighestValue = Math.ceil(maxValue * 1.1);

            if (bardata.datasets && bardata.datasets.length > 0) {
                bardata.datasets.forEach(dataset => {
                    dataset.backgroundColor = 'red';
                });
            }

            window.matchRatingTopChartInstance = new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true,
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            // rotation: -90,
                            formatter: value => value
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: nextHighestValue,
                            ticks: {
                                font: { size: 10 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        },
                        x: {
                            barPercentage: 0.6,
                            ticks: {
                                font: { size: 11 },
                                color: "rgba(171, 167, 167,0.9)",
                                callback: function(value) {
                                    return this.getLabelForValue(value);
                                },
                                maxRotation: 90,
                                minRotation: 90
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            document.getElementById('exportBtn_tv_match_ratings_1').addEventListener('click', function () {
                const imageUrl = window.matchRatingTopChartInstance.toBase64Image();
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'match_ratings_top_chart.png';
                link.click();
            });
        },
        error: function (xhr, status, error) {
            console.error("Rating chart load failed:", error);
        }
    });
}

function load_match_rating_bottom() {
    $.ajax({
        url: 'api/match_rating_chart_bottom.php',
        type: 'POST',
        dataType: 'json',
        success: function (bardata) {
            const ctx1 = document.getElementById('tv_match_ratings_bottom').getContext('2d');

            // Clean up previous chart instance
            if (window.matchRatingBottomChartInstance) {
                window.matchRatingBottomChartInstance.destroy();
            }

            const maxValue = Math.max(...bardata.datasets.flatMap(dataset => dataset.data));
            const nextHighestValue = Math.ceil(maxValue * 1.1);

            if (bardata.datasets && bardata.datasets.length > 0) {
                bardata.datasets.forEach(dataset => {
                    dataset.backgroundColor = '#2A2E4B';
                });
            }

            window.matchRatingBottomChartInstance = new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: bardata.labels,
                    datasets: bardata.datasets
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true,
                        },
                        datalabels: {
                            anchor: 'end',
                            align: 'end',
                            color: '#000',
                            font: {
                                size: 10,
                                weight: 'bold'
                            },
                            // rotation: -90,
                            formatter: value => value
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: nextHighestValue,
                            ticks: {
                                font: { size: 10 },
                                color: "rgba(171, 167, 167,0.9)"
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        },
                        x: {
                            barPercentage: 0.6,
                            ticks: {
                                font: { size: 11 },
                                color: "rgba(171, 167, 167,0.9)",
                                callback: function(value) {
                                    return this.getLabelForValue(value);
                                },
                                maxRotation: 90,
                                minRotation: 90
                            },
                            grid: { display: false },
                            borderColor: 'rgba(171, 167, 167,0.9)',
                            borderWidth: 1
                        }
                    }
                },
                plugins: [ChartDataLabels]
            });

            document.getElementById('exportBtn_tv_match_ratings_2').addEventListener('click', function () {
                const imageUrl = window.matchRatingBottomChartInstance.toBase64Image();
                const link = document.createElement('a');
                link.href = imageUrl;
                link.download = 'match_ratings_bottom_chart.png';
                link.click();
            });
        },
        error: function (xhr, status, error) {
            console.error("Rating chart load failed:", error);
        }
    });
}

function get_comments() {
    $.ajax({
        url: 'api/get_reach_rating_comments.php',
        type: 'POST',
        dataType: 'json',
        success: function (response) {
            $('#rating_comment').html(response['rating_comments']);
            $('#reach_comment').html(response['reach_comments']);
        },
        error: function (xhr, status, error) {
            console.error("Comments load failed:", error);
        }
    });
}