<?php
header('Content-Type: application/json');

$uploadDir = '../csv/';
$response = [];

include_once('db.php');

// Currency cleaner function
function cleanCurrency($value) {
	$value = preg_replace('/[₹,\s]/u', '', $value);
	return is_numeric($value) ? (float)$value : 0.0;
}

function stingToDate($dateString) {
	$date = DateTime::createFromFormat('d-M-y', $dateString);
	return $date ? $date->format('Y-m-d') : "0000-00-00";
}

try {
	$pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
	echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
	exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if (isset($_FILES['importRatingsFormCsvFile']) && $_FILES['importRatingsFormCsvFile']['error'] === UPLOAD_ERR_OK) {
		$fileTmpPath = $_FILES['importRatingsFormCsvFile']['tmp_name'];
		$fileName = $_FILES['importRatingsFormCsvFile']['name'];
		$fileNameCmps = explode(".", $fileName);
		$fileExtension = strtolower(end($fileNameCmps));

		$allowedExtensions = ['csv'];

		if (in_array($fileExtension, $allowedExtensions)) {
			$newFileName = 'ratings_data_' . date('YmdHis') . '.' . $fileExtension;
			$destPath = $uploadDir . $newFileName;

			if (move_uploaded_file($fileTmpPath, $destPath)) {

				// try {
				// 	$pdo->exec("TRUNCATE TABLE ipl_data");
				// } catch (PDOException $e) {
				// 	echo json_encode(['status' => 'error', 'message' => 'Failed to truncate table: ' . $e->getMessage()]);
				// 	exit;
				// }

				if (($handle = fopen($destPath, "r")) !== false) {
					$headers = fgetcsv($handle);

					// Check and remove BOM (Byte Order Mark) if it exists
					foreach ($headers as &$header) {
						// Remove BOM (if exists) at the beginning of the header
						$header = preg_replace('/^\xEF\xBB\xBF/', '', $header); // Remove BOM
						
						// Trim any extra spaces from the headers
						$header = trim($header);
					}

					$headers = array_map('trim', $headers); // trim extra spaces
					$rowCount = 0;

					// Map columns
					$colMap = [
						'IPL'   => null,
						'TVR'   => null,
						'Comment'     => null
					];

					foreach ($colMap as $key => $value) {
						$index = array_search($key, $headers);
						if ($index !== false) {
							$colMap[$key] = $index;
						} else {
							$response = ['status' => 'error', 'message' => "Missing column: $key","Headers" => $headers];
							echo json_encode($response);
							exit;
						}
					}

					$sql = "INSERT IGNORE INTO ipl_ratings (
								ipl,
								tvr,
								comment
							) VALUES (?, ?, ?)";
							
					$stmt = $pdo->prepare($sql);

					while (($data = fgetcsv($handle, 1000, ",")) !== false) {
						if (count($data) < count($headers)) continue;

						$ratings = str_replace(",", "", $data[$colMap['TVR']]);


						$stmt->execute([
							$data[$colMap['IPL']],
							(float) $ratings,
							$data[$colMap['Comment']]
						]);

						$rowCount++;
					}

					fclose($handle);

					$response = [
						'status' => 'success',
						'message' => "File uploaded and $rowCount rows imported.",
						'fileName' => $newFileName
					];
				} else {
					$response = ['status' => 'error', 'message' => 'Failed to read the uploaded CSV file.'];
				}
			} else {
				$response = ['status' => 'error', 'message' => 'Error moving uploaded file.'];
			}
		} else {
			$response = ['status' => 'error', 'message' => 'Invalid file type. Only .csv allowed.'];
		}
	} else {
		$response = ['status' => 'error', 'message' => 'No file uploaded or upload error.'];
	}
} else {
	$response = ['status' => 'error', 'message' => 'Invalid request method.'];
}

echo json_encode($response);
?>
