<?php
header('Content-Type: application/json');
include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Build base query
    $sql = "
        SELECT 
            upper(ipl) AS label,
            ROUND(SUM(tvr),2) AS net_total
        FROM ipl_ratings
    ";

    $params = [];

    $sql .= " GROUP BY 1";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare chart data
    $labels = [];
    $totals = [];

    foreach ($rows as $row) {
        $labels[] = $row['label'];
        $totals[] = (float)$row['net_total'];
    }

    // Return JSON for Chart.js
    echo json_encode([
        'labels' => $labels,
        'datasets' => [
            [
                'label' => 'TV Ratings',
                'data' => $totals
            ]
        ]
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
