<?php
include_once("header.php");
include_once("menu.php");
?>

<!-- main-content -->
<div class="main-content app-content">
    <!-- container -->
    <div class="main-container container-fluid">
        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="left-content">
                <div>
                    <h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1"><?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025 Brand Lift Survey – Exposed Group</h2>
                    <small>Sample size: 11,500 respondents from Tier 1 and Tier 2 urban India</small>
                </div>
            </div>
            <div class="main-dashboard-header-right">

            </div>
        </div>
        <!-- breadcrumb -->


        <!-- A2 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">A2. How many matches did you watch?</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Matches Watched</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Percentage (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Count (n=11,500)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">1-3</td>
                                            <td class="text-center">32</td>
                                            <td class="text-center">3680</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">4-7</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">3220</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">8-15</td>
                                            <td class="text-center">24</td>
                                            <td class="text-center">2760</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">16+</td>
                                            <td class="text-center">16</td>
                                            <td class="text-center">1840</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q1" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-220 ht-lg-220 position-relative">
                                    <canvas id="chartq1" style="width: 275px; height: 275px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- A3 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">A3. Platforms Used to Follow <?php echo $_SESSION['cricket_user_group_short_name']; ?></h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Platform</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Percentage (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Count (n=11,500)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">OTT (e.g., JioCinema)</td>
                                            <td class="text-center">82</td>
                                            <td class="text-center">9430</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Social Media</td>
                                            <td class="text-center">72</td>
                                            <td class="text-center">8280</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Live TV</td>
                                            <td class="text-center">64</td>
                                            <td class="text-center">7360</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">YouTube Highlights</td>
                                            <td class="text-center">59</td>
                                            <td class="text-center">6785</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center"><?php echo $_SESSION['cricket_user_group_short_name']; ?>T20.com</td>
                                            <td class="text-center">25</td>
                                            <td class="text-center">2875</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">In Stadium</td>
                                            <td class="text-center">8</td>
                                            <td class="text-center">920</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q2" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-250 ht-lg-250 position-relative">
                                    <canvas id="chartq2" style="width: 100%; height: 275px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- A4 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">A4. How Closely Did You Follow <?php echo $_SESSION['cricket_user_group_short_name']; ?> (Scale 1–5)</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Rating</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Percentage (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Count (n=11,500)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">1</td>
                                            <td class="text-center">3</td>
                                            <td class="text-center">345</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">2</td>
                                            <td class="text-center">6</td>
                                            <td class="text-center">690</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">3</td>
                                            <td class="text-center">23</td>
                                            <td class="text-center">2645</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">4</td>
                                            <td class="text-center">35</td>
                                            <td class="text-center">4025</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">5</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">3795</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q3" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-250 ht-lg-250 position-relative">
                                    <canvas id="chartq3" style="width: 90%; height: 275px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- A5 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">A5. Did You Follow the TATA <?php echo $_SESSION['cricket_user_group_short_name']; ?> Auction 2025?</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Response</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Percentage (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Count (n=11,500)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">Yes</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">7015</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">No</td>
                                            <td class="text-center">39</td>
                                            <td class="text-center">4485</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q4" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-250 ht-lg-250 position-relative">
                                    <canvas id="chartq4" style="width: 100%; height: 200px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- B2 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">B2. Aided Brand Recall for <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025 Sponsors</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Strongly Recall</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Somewhat Recall</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No Recall</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">69</td>
                                            <td class="text-center">24</td>
                                            <td class="text-center">7</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">55</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">17</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">46</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">21</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">41</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">23</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">42</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">25</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">32</td>
                                            <td class="text-center">38</td>
                                            <td class="text-center">30</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">30</td>
                                            <td class="text-center">34</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">24</td>
                                            <td class="text-center">31</td>
                                            <td class="text-center">45</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q5" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq5" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- C1 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">C1. Average Brand Awareness After <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Avg Awareness Score (out of 5)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">4.5</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">4.2</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">3.9</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">3.7</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">3.8</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">3.2</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">3.5</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">2.9</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q6" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-250 ht-lg-250 position-relative">
                                    <canvas id="chartq6" style="width: 90%; height: 275px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- C2 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">C2. Favorability to Switch Based on <?php echo $_SESSION['cricket_user_group_short_name']; ?> Association</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Very Likely (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Maybe (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not at All (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">52</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">12</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">38</td>
                                            <td class="text-center">39</td>
                                            <td class="text-center">23</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">40</td>
                                            <td class="text-center">27</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">45</td>
                                            <td class="text-center">27</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">30</td>
                                            <td class="text-center">40</td>
                                            <td class="text-center">30</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">21</td>
                                            <td class="text-center">47</td>
                                            <td class="text-center">32</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">27</td>
                                            <td class="text-center">42</td>
                                            <td class="text-center">31</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">19</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">48</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q7" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq7" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- C3 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">C3. Do You Think Each Brand is a Good Fit for <?php echo $_SESSION['cricket_user_group_short_name']; ?>?</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Yes (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not Sure (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">81</td>
                                            <td class="text-center">8</td>
                                            <td class="text-center">11</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">74</td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">16</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">70</td>
                                            <td class="text-center">13</td>
                                            <td class="text-center">17</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">67</td>
                                            <td class="text-center">14</td>
                                            <td class="text-center">19</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">63</td>
                                            <td class="text-center">18</td>
                                            <td class="text-center">19</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">59</td>
                                            <td class="text-center">21</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">19</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">48</td>
                                            <td class="text-center">26</td>
                                            <td class="text-center">26</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q8" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq8" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- D1 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">D1. Recall of Ad or Campaign During <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Yes (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not Sure (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">75</td>
                                            <td class="text-center">16</td>
                                            <td class="text-center">9</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">25</td>
                                            <td class="text-center">14</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">52</td>
                                            <td class="text-center">31</td>
                                            <td class="text-center">17</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">57</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">15</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">46</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">18</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">43</td>
                                            <td class="text-center">37</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">39</td>
                                            <td class="text-center">41</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">30</td>
                                            <td class="text-center">50</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q9" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq9" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- D3 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">D3. Interaction with Brands During <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Yes (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not Sure (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">42</td>
                                            <td class="text-center">45</td>
                                            <td class="text-center">13</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">55</td>
                                            <td class="text-center">17</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">34</td>
                                            <td class="text-center">50</td>
                                            <td class="text-center">16</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">22</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">17</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">24</td>
                                            <td class="text-center">56</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">18</td>
                                            <td class="text-center">63</td>
                                            <td class="text-center">19</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">20</td>
                                            <td class="text-center">58</td>
                                            <td class="text-center">22</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">15</td>
                                            <td class="text-center">65</td>
                                            <td class="text-center">20</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q10" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq10" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- E1 vs E2 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">E1 vs E2. Brand Consideration Before and After <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Before <?php echo $_SESSION['cricket_user_group_short_name']; ?></th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">After <?php echo $_SESSION['cricket_user_group_short_name']; ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">4.1</td>
                                            <td class="text-center">4.6</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">3.5</td>
                                            <td class="text-center">4.3</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">3.2</td>
                                            <td class="text-center">4.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">2.9</td>
                                            <td class="text-center">3.8</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">3.0</td>
                                            <td class="text-center">3.9</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">2.4</td>
                                            <td class="text-center">3.3</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">2.8</td>
                                            <td class="text-center">3.6</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">2.2</td>
                                            <td class="text-center">2.9</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q11" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq11" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- F1 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">F1. More Likely to Buy or Use the Brand After <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Yes (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not Sure (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">24</td>
                                            <td class="text-center">15</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">44</td>
                                            <td class="text-center">30</td>
                                            <td class="text-center">26</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">35</td>
                                            <td class="text-center">38</td>
                                            <td class="text-center">27</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">39</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">25</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">36</td>
                                            <td class="text-center">37</td>
                                            <td class="text-center">27</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">28</td>
                                            <td class="text-center">42</td>
                                            <td class="text-center">30</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">33</td>
                                            <td class="text-center">39</td>
                                            <td class="text-center">28</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">25</td>
                                            <td class="text-center">49</td>
                                            <td class="text-center">26</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q13" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq13" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- F2 -->
        <div class="row row-sm align-items-stretch">
            <div class="col-lg-12 col-xl-12 d-flex">
                <div class="card card-dashboard-map-one w-100">

                    <div class="card-header">
                        <h3 class="card-title">F2. Actual Purchase or Usage During <?php echo $_SESSION['cricket_user_group_short_name']; ?> 2025</h3>
                    </div>

                    <div class="card-body" style="padding: 1px !important;">

                        <div class="row">
                            <div class="col-md-8">
                                <table class="table border-top-0 table-bordered border-bottom" id="datametrics-table">
                                    <thead>
                                        <tr style="text-align: right;">
                                            <th class="border-bottom-0 text-center bg-light text-bold">Brand</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Yes (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">No (%)</th>
                                            <th class="border-bottom-0 text-center bg-light text-bold">Not Sure (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">TATA</td>
                                            <td class="text-center">38.0</td>
                                            <td class="text-center">49</td>
                                            <td class="text-center">13.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">RuPay</td>
                                            <td class="text-center">31.0</td>
                                            <td class="text-center">54</td>
                                            <td class="text-center">15.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">MY11Circle</td>
                                            <td class="text-center">24.0</td>
                                            <td class="text-center">61</td>
                                            <td class="text-center">15.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Ceat Tyres</td>
                                            <td class="text-center">16.0</td>
                                            <td class="text-center">70</td>
                                            <td class="text-center">14.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Neu</td>
                                            <td class="text-center">17.0</td>
                                            <td class="text-center">67</td>
                                            <td class="text-center">16.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Angel One</td>
                                            <td class="text-center">14.0</td>
                                            <td class="text-center">72</td>
                                            <td class="text-center">14.0</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">TATA Curvv</td>
                                            <td class="text-center">1.5</td>
                                            <td class="text-center">85</td>
                                            <td class="text-center">13.5</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center">Wonder Cement</td>
                                            <td class="text-center">12.0</td>
                                            <td class="text-center">73</td>
                                            <td class="text-center">15.0</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4" style="text-align:center !important">
                                <!-- Export Button -->
                                <button id="exportBtn_q14" class="btn btn-primary btn-sm exportBtn_barchart_button3">PNG</button>

                                <div class="ht-280 ht-lg-280 position-relative">
                                    <canvas id="chartq14" style="width: 90%; height: 300px"></canvas>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>


    </div>
</div>
<!-- /main-content -->

<?php
include_once("footer.php");
?>
<script src="assets/js/research.js?cache=<?php echo date("YmdHis") . rand(1, 10000); ?>"></script>