function importSponsorshipData() {
    var formData = new FormData($('#importSponsorshipForm')[0]);
    var importBtn = $('#importSponsorshipButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/sponsorship-data-upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importSponsorshipAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importSponsorshipModal').modal('hide');
                        alertBox.hide();
                        // window.location.reload();
                        load_brands(function () {
                            // Only call filter_data *after* brands are loaded
                            filter_data();
                        });
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importSponsorshipAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importSponsorshipAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}

function importRatingsData() {
    var formData = new FormData($('#importRatingsForm')[0]);
    var importBtn = $('#importRatingsButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/ratings-data-upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importRatingsAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importRatingsModal').modal('hide');
                        alertBox.hide();
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importRatingsAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importRatingsAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}

function importReachData() {
    var formData = new FormData($('#importReachForm')[0]);
    var importBtn = $('#importReachButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/reach-data-upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importReachAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importRatingsModal').modal('hide');
                        alertBox.hide();
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importReachAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importReachAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}

function importRatingTopSection() {
    var formData = new FormData($('#importMatchRatingTopForm')[0]);
    var importBtn = $('#importMatchRatingTopButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/match-rating-top-data-upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importMatchRatingTopAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importMatchRatingTopModal').modal('hide');
                        alertBox.hide();
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importMatchRatingTopAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importMatchRatingTopAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}

function importRatingBottomSection() {
    var formData = new FormData($('#importMatchRatingBottomForm')[0]);
    var importBtn = $('#importMatchRatingBottomButton');
    var spinner = importBtn.find('.spinner-border');
    var btnText = importBtn.find('.btn-text');

    // Disable button and show spinner
    importBtn.prop('disabled', true);
    spinner.removeClass('d-none');
    btnText.text('Uploading...');

    $.ajax({
        url: 'api/match-rating-bottom-data-upload.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                var jsonResponse = response;
                var alertBox = $('#importMatchRatingBottomAlert');
                alertBox.removeClass('alert-danger alert-warning alert-success');

                if (jsonResponse.status === 'success') {
                    alertBox.addClass('alert-success');
                    alertBox.html('<strong>' + (jsonResponse.message || 'The CSV file has been imported successfully.') + '</strong>');
                    alertBox.show();

                    // Close modal after 1 second
                    setTimeout(function () {
                        $('#importMatchRatingBottomModal').modal('hide');
                        alertBox.hide();
                        refresh_screen();
                    }, 1000);
                } else {
                    alertBox.addClass('alert-danger');
                    alertBox.html('<strong>' + (jsonResponse.message || 'Please try again.') + '</strong>');
                    alertBox.show();
                }
            } catch (e) {
                console.log(e);
                var alertBox = $('#importMatchRatingBottomAlert');
                alertBox.removeClass('alert-success alert-warning').addClass('alert-danger');
                alertBox.text('Invalid response from the server.');
                alertBox.show();
            }
        },
        error: function () {
            var alertBox = $('#importMatchRatingBottomAlert');
            alertBox.removeClass('alert-success').addClass('alert-danger');
            alertBox.text('An error occurred while uploading the file.');
            alertBox.show();
        },
        complete: function () {
            // Re-enable button and hide spinner
            importBtn.prop('disabled', false);
            spinner.addClass('d-none');
            btnText.text('Import');
        }
    });
}