<?php
session_start();
header('Content-Type: application/json');
include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Fetch the dynamic label from match_ratings_col_map
    $labelQuery = "SELECT col2 FROM match_ratings_col_map WHERE user_group= ". $_SESSION['cricket_user_group'] . " col_type = 1 LIMIT 1";
    $labelStmt = $pdo->query($labelQuery);
    $labelRow = $labelStmt->fetch(PDO::FETCH_ASSOC);
    $chartLabel = $labelRow ? $labelRow['col2'] : 'IPL Ratings';

    // Build base query
    $sql = "
        SELECT 
           upper(col1) AS label,
           col2 AS net_total
        FROM match_rating_top
        WHERE user_group= ". $_SESSION['cricket_user_group'] . "
    ";

    $params = [];

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare chart data
    $labels = [];
    $totals = [];

    foreach ($rows as $row) {
        $labels[] = $row['label'];
        $totals[] = $row['net_total']>0 ? (float)$row['net_total'] : "";
    }

    // Return JSON for Chart.js
    echo json_encode([
        'labels' => $labels,
        'datasets' => [
            [
                'label' => $chartLabel,
                'data' => $totals
            ]
        ]
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
