<?php
session_start();
header('Content-Type: application/json');

$uploadDir = '../csv/';
$response = [];

include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['importMatchRatingBottomFormCsvFile']) && $_FILES['importMatchRatingBottomFormCsvFile']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['importMatchRatingBottomFormCsvFile']['tmp_name'];
        $fileName = $_FILES['importMatchRatingBottomFormCsvFile']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

        if ($fileExtension === 'csv') {
            $newFileName = 'match_ratings_bottom_data_' . date('YmdHis') . '.' . $fileExtension;
            $destPath = $uploadDir . $newFileName;

            if (move_uploaded_file($fileTmpPath, $destPath)) {
                try {
                    $pdo->exec("TRUNCATE TABLE match_rating_bottom");
                } catch (PDOException $e) {
                    echo json_encode(['status' => 'error', 'message' => 'Failed to truncate match_rating_bottom: ' . $e->getMessage()]);
                    exit;
                }

                if (($handle = fopen($destPath, "r")) !== false) {
                    $headers = fgetcsv($handle); // Read header row

                    if (count($headers) < 2) {
                        echo json_encode(['status' => 'error', 'message' => 'CSV must contain at least 2 columns.']);
                        exit;
                    }

                    // Clean headers and handle BOM
                    $col1Header = trim(preg_replace('/^\xEF\xBB\xBF/', '', $headers[0]));
                    $col2Header = trim($headers[1]);

                    try {
                        // Clear existing col_type = 2
                        $pdo->prepare("DELETE FROM match_ratings_col_map WHERE  user_group= ". $_SESSION['cricket_user_group'] . " col_type = 2")->execute();

                        // Insert new headers
                        $insertHeaderSql = "
                            INSERT INTO match_ratings_col_map (user_group, col_type, col1, col2)
                            VALUES (:user_group, 2, :col1, :col2)
                        ";
                        $insertHeaderStmt = $pdo->prepare($insertHeaderSql);
                        $insertHeaderStmt->execute([
                            ':user_group' => $_SESSION['cricket_user_group'],
                            ':col1' => $col1Header,
                            ':col2' => $col2Header
                        ]);
                    } catch (PDOException $e) {
                        echo json_encode(['status' => 'error', 'message' => 'Failed to insert headers: ' . $e->getMessage()]);
                        exit;
                    }

                    $rowCount = 0;
                    $sql = "INSERT IGNORE INTO match_rating_bottom (user_group, col1, col2) VALUES (?, ?, ?)";
                    $stmt = $pdo->prepare($sql);

                    while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                        if (count($data) < 2) continue;

                        $col1 = trim($data[0]);
                        $col2 = (float)str_replace(",", "", $data[1]);

                        $stmt->execute([$_SESSION['cricket_user_group'], $col1, $col2]);
                        $rowCount++;
                    }

                    fclose($handle);

                    $response = [
                        'status' => 'success',
                        'message' => "File uploaded and $rowCount rows imported.",
                        'fileName' => $newFileName
                    ];
                } else {
                    $response = ['status' => 'error', 'message' => 'Failed to read the uploaded CSV file.'];
                }
            } else {
                $response = ['status' => 'error', 'message' => 'Error moving uploaded file.'];
            }
        } else {
            $response = ['status' => 'error', 'message' => 'Invalid file type. Only .csv allowed.'];
        }
    } else {
        $response = ['status' => 'error', 'message' => 'No file uploaded or upload error.'];
    }
} else {
    $response = ['status' => 'error', 'message' => 'Invalid request method.'];
}

echo json_encode($response);
