<?php
session_start();
header('Content-Type: application/json');

include_once('db.php');

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Query to fetch distinct brand names ordered by brand
    $sql = "SELECT DISTINCT brand FROM cricket_data WHERE user_group= ". $_SESSION['cricket_user_group'] . " ORDER BY brand";
    $stmt = $pdo->query($sql);
    $brands = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare brand options
    $brandOptions = [];
    foreach ($brands as $brand) {
        $brandOptions[] = [
            'value' => $brand['brand'],
            'text'  => $brand['brand']
        ];
    }

    // Query to fetch distinct match names ordered by matches
    $match_sql = "SELECT DISTINCT match_name FROM cricket_data WHERE user_group= ". $_SESSION['cricket_user_group'] . " ORDER BY match_name";
    $match_stmt = $pdo->query($match_sql);
    $matches = $match_stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare match options
    $matchOptions = [];
    foreach ($matches as $match) {
        $matchOptions[] = [
            'value' => $match['match_name'],
            'text'  => $match['match_name']
        ];
    }

    // Query to fetch distinct match names ordered by matches
    $asset_sql = "SELECT DISTINCT location as asset FROM cricket_data WHERE user_group= ". $_SESSION['cricket_user_group'] . " ORDER BY location";
    $asset_stmt = $pdo->query($asset_sql);
    $assets = $asset_stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare asset options
    $assetOptions = [];
    foreach ($assets as $asset) {
        $assetOptions[] = [
            'value' => $asset['asset'],
            'text'  => $asset['asset']
        ];
    }

    // Get min and max match dates
    $dateStmt = $pdo->query("SELECT MIN(match_date) AS min_date, MAX(match_date) AS max_date from cricket_data WHERE user_group= ". $_SESSION['cricket_user_group'] . "");
    $dateRange = $dateStmt->fetch(PDO::FETCH_ASSOC);

    // Return everything as JSON
    echo json_encode([
        'brands'      => $brandOptions,
        'matches'      => $matchOptions,
        'assets'      => $assetOptions,
        'match_dates' => [
            'min' => $dateRange['min_date'],
            'max' => $dateRange['max_date']
        ]
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'error' => true,
        'message' => 'DB Error: ' . $e->getMessage()
    ]);
}
?>
