-- Brand Lift Study bootstrap
-- Safe to run multiple times (idempotent).

-- 1) Create database
CREATE DATABASE IF NOT EXISTS bls
  DEFAULT CHARACTER SET utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

-- 2) Use database
USE bls;

-- 3) Create table (wide format)
CREATE TABLE IF NOT EXISTS bls_scores (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  Event         VARCHAR(255) NOT NULL,
  BRAND         VARCHAR(255) NOT NULL,
  Metric        VARCHAR(255) NOT NULL,
  Control       DECIMAL(16,4) NULL,
  Exposed_Pre   DECIMAL(16,4) NULL,
  Exposed_Post  DECIMAL(16,4) NULL,
  created_at    DATETIME NULL,
  updated_at    DATETIME NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_event_brand_metric (Event, BRAND, Metric),
  KEY idx_event_brand (Event, BRAND)
);

-- 4) Seed data for "Australia Women Tour of India, 2025"

INSERT INTO bls_scores
  (Event, BRAND, Metric, Control, Exposed_Pre, Exposed_Post, created_at, updated_at)
VALUES
/* IDFC FIRST BANK */
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Unaided Brand Recall (Finance)', 0.0510, 0.1130, 0.1840, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Aided Brand Recall',             0.2440, 0.4110, 0.6130, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Top Finance Brand in Series',    0.0730, 0.1640, 0.2930, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Saw Ad or Mention During Series',0.0210, 0.1920, 0.3470, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Favorable Opinion (4–5)',        0.2470, 0.3220, 0.4580, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Would Consider / Open Account',  0.1170, 0.1840, 0.2690, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Likely to Register',             0.0370, 0.0830, 0.1430, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Brand Fit with Series',          0.3140, 0.4310, 0.5920, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'IDFC FIRST BANK', 'Series Improved View of IDFC First Bank', 0.0460, 0.0970, 0.2040, NOW(), NOW()),

/* SBI LIFE */
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Unaided Brand Recall (Insurance)', 0.0720, 0.1380, 0.2310, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Aided Brand Recall',               0.2710, 0.4140, 0.5240, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Top Insurance Brand in Series',    0.0850, 0.1270, 0.1850, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Saw Ad or Mention During Series',  0.0380, 0.1250, 0.2560, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Favorable Opinion (4–5)',          0.2920, 0.3580, 0.4760, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Would Consider Policy',            0.1340, 0.1810, 0.2470, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Likely to Register',               0.0580, 0.0810, 0.1360, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Brand Fit with Series',            0.3550, 0.4380, 0.6040, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'SBI LIFE', 'Series Improved View of SBI Life', 0.0720, 0.1040, 0.1970, NOW(), NOW()),

/* CAMPA */
('Australia Women Tour of India, 2025', 'CAMPA', 'Unaided Brand Recall (Beverage)', 0.0200, 0.0300, 0.0450, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Aided Brand Recall',              0.1200, 0.1500, 0.2200, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Top Beverage Brand in Series',    0.0300, 0.0500, 0.0800, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Saw Ad or Mention During Series', 0.0160, 0.0430, 0.0950, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Favorable Opinion (4–5)',         0.2360, 0.2890, 0.3530, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Would Consider / Try',            0.1220, 0.1530, 0.2050, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Brand Fit with Series',           0.2880, 0.3410, 0.4590, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'CAMPA', 'Series Improved View of Campa',   0.0470, 0.0670, 0.1430, NOW(), NOW()),

/* ATOMBERG */
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Unaided Brand Recall (Appliance)', 0.0230, 0.0470, 0.0660, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Aided Brand Recall',               0.1720, 0.2240, 0.3070, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Top Appliance Brand in Series',    0.0310, 0.0460, 0.0780, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Saw Ad or Mention During Series',  0.0120, 0.0370, 0.0870, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Favorable Opinion (4–5)',          0.2180, 0.2770, 0.3450, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Would Consider / Buy',             0.1080, 0.1370, 0.1880, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Brand Fit with Series',            0.2650, 0.3120, 0.4180, NOW(), NOW()),
('Australia Women Tour of India, 2025', 'ATOMBERG', 'Series Improved View of Atomberg', 0.0410, 0.0560, 0.1220, NOW(), NOW())
ON DUPLICATE KEY UPDATE
  Control = VALUES(Control),
  Exposed_Pre = VALUES(Exposed_Pre),
  Exposed_Post = VALUES(Exposed_Post),
  updated_at = NOW();
