// Chat dock injector (additive; no edits to your existing HTML required)
// Assumes your page already defines #eventSelect and #brandSelect.

(function(){
  function h(tag, attrs={}, html=''){
    const el = document.createElement(tag);
    Object.entries(attrs).forEach(([k,v]) => el.setAttribute(k, v));
    if (html) el.innerHTML = html;
    return el;
  }

  function buildDock(){
    if (document.getElementById('chatDock')) return;

    const dock = h('div', { id:'chatDock', class:'screen-only' });
    const head = h('div', { class:'chat-head' },
      `<div class="chat-title">Ask the Data</div>
       <button id="chatToggle" title="Minimize">—</button>`);
    const hist = h('div', { id:'chatHistory' });
    const input = h('div', { class:'chat-input' },
      `<input type="text" id="chatText" placeholder="Ask about brands, lifts, events..." />
       <button id="chatSend">Send</button>`);

    dock.appendChild(head);
    dock.appendChild(hist);
    dock.appendChild(input);
    document.body.appendChild(dock);

    // wiring
    const chatHist  = hist;
    const chatText  = dock.querySelector('#chatText');
    const chatSend  = dock.querySelector('#chatSend');
    const chatToggle= dock.querySelector('#chatToggle');

    function appendMsg(who, text){
      const div = document.createElement('div');
      div.className = who === 'user' ? 'msg-user' : 'msg-bot';
      div.textContent = text;
      chatHist.appendChild(div);
      chatHist.scrollTop = chatHist.scrollHeight;
    }
    function renderTable(rows){
      if (!rows || !rows.length) return;
      const cols = Object.keys(rows[0]);
      const wrap = document.createElement('div');
      wrap.className = 'msg-bot';
      const table = document.createElement('table');
      table.className = 'chat-table';
      const thead = document.createElement('thead');
      thead.innerHTML = '<tr>'+cols.map(c=>`<th>${c}</th>`).join('')+'</tr>';
      const tbody = document.createElement('tbody');
      tbody.innerHTML = rows.map(r => '<tr>'+cols.map(c=>`<td>${r[c] ?? ''}</td>`).join('')+'</tr>').join('');
      table.appendChild(thead); table.appendChild(tbody);
      wrap.appendChild(table);
      chatHist.appendChild(wrap);
      chatHist.scrollTop = chatHist.scrollHeight;
    }
    async function askData(q){
  appendMsg('user', q);
  const eventSel = document.getElementById('eventSelect');
  const brandSel = document.getElementById('brandSelect');
  const url = './chat.php?q='+encodeURIComponent(q)
            + '&event='+encodeURIComponent(eventSel?.value || '')
            + '&brand='+encodeURIComponent(brandSel?.value || '');
  try {
    const r = await fetch(url, { cache: 'no-store' });
    const j = await r.json();
    if (j.error){ appendMsg('bot', '⚠️ ' + j.error); return; }
    if (j.answer) appendMsg('bot', j.answer);
    if (j.rows?.length > 0) renderTable(j.rows);
  } catch(e){
    appendMsg('bot','⚠️ Request failed: ' + e.message);
  }
}

    chatSend?.addEventListener('click', ()=> {
      const q = chatText.value.trim();
      if (!q) return;
      chatText.value = '';
      askData(q);
    });
    chatText?.addEventListener('keydown', (e)=>{
      if (e.key === 'Enter') chatSend.click();
    });
    chatToggle?.addEventListener('click', ()=>{
      dock.classList.toggle('min');
      chatToggle.textContent = dock.classList.contains('min') ? '+' : '—';
    });
  }

  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', buildDock);
  } else {
    buildDock();
  }
})();
