<?php
require __DIR__.'/config.php';
header('Content-Type: application/json');

$action = $_GET['action'] ?? 'data';
$event  = $_GET['event']  ?? '';
$brand  = $_GET['brand']  ?? '';
$event  = trim($event);
$brand  = trim($brand);

try {
  $pdo = db();

  switch ($action) {
    case 'events':
      $rows = $pdo->query("SELECT DISTINCT Event FROM bls_scores WHERE Event<>'' ORDER BY Event")->fetchAll();
      echo json_encode(array_column($rows, 'Event'));
      break;

    case 'brands':
      $q = $pdo->prepare("SELECT DISTINCT BRAND FROM bls_scores WHERE Event=? AND BRAND<>'' ORDER BY BRAND");
      $q->execute([$event]);
      echo json_encode(array_column($q->fetchAll(), 'BRAND'));
      break;

    case 'data':
    default:
      $q = $pdo->prepare("
        SELECT Metric, Control, Exposed_Pre, Exposed_Post, Sample_Size, Target_Group
        FROM bls_scores
        WHERE Event=? AND BRAND=?
        ORDER BY Metric
      ");
      $q->execute([$event, $brand]);
      $rows = $q->fetchAll();

      // get meta info (Sample_Size and Target_Group) from first row
      $meta = null;
      if (!empty($rows)) {
        $meta = [
          'Sample_Size' => $rows[0]['Sample_Size'] ?? null,
          'Target_Group' => $rows[0]['Target_Group'] ?? null
        ];
      }

      echo json_encode(['rows'=>$rows, 'meta'=>$meta]);
      break;
  }

} catch (Exception $e) {
  echo json_encode(['error'=>$e->getMessage()]);
}
?>
