CREATE TABLE IF NOT EXISTS pb_seasons(
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(120),
matches_count INT,
default_rate_per_sec DECIMAL(10,4),
sell_through_factor DECIMAL(6,4),
currency VARCHAR(10)
);

CREATE TABLE IF NOT EXISTS pb_assets(
id INT AUTO_INCREMENT PRIMARY KEY,
asset_group VARCHAR(50),
name VARCHAR(140),
unit VARCHAR(20),
weight DECIMAL(6,3),
visibility_default DECIMAL(6,3),
context_default DECIMAL(6,3),
platform_default DECIMAL(6,3),
tier_min VARCHAR(30),
is_active TINYINT DEFAULT 1
);

CREATE TABLE IF NOT EXISTS pb_proposals(
id INT AUTO_INCREMENT PRIMARY KEY,
season_id INT,
sponsor_name VARCHAR(140),
tier VARCHAR(30),
projected_media_value DECIMAL(14,2),
recommended_fee DECIMAL(14,2)
);

CREATE TABLE IF NOT EXISTS pb_proposal_assets(
id INT AUTO_INCREMENT PRIMARY KEY,
proposal_id INT,
asset_id INT,
expected_per_match DECIMAL(10,2),
matches_included INT
);
